/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescriptionKey;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.editor.DisplayExpressionPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.DescriptionProcessor;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class DescriptionProcessorTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_decriptionForCustomComponent_disableParent() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite fakeParent, int style, Composite realParent) {", "    super(realParent, style);", "  }", "}"));
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.wbp-component.xml", DescriptionProcessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='org.eclipse.swt.widgets.Composite'>", "        <tag name='parent' value='false'/>", "      </parameter>", "      <parameter type='int'/>", "      <parameter type='org.eclipse.swt.widgets.Composite' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        DescriptionProcessorTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComposite");
        ConstructorDescription constructorDescription = (ConstructorDescription)description.getConstructors().get(0);
        ParameterDescription parameter_0 = constructorDescription.getParameter(0);
        DescriptionProcessorTest.assertFalse((boolean)parameter_0.isParent());
        ParameterDescription styleParameter = constructorDescription.getParameter(1);
        DescriptionProcessorTest.assertInstanceOf(StylePropertyEditor.class, (Object)styleParameter.getEditor());
        ParameterDescription parameter_2 = constructorDescription.getParameter(2);
        DescriptionProcessorTest.assertTrue((boolean)parameter_2.isParent());
    }

    @Test
    public void test_decriptionForCustomComponent_parentStyle() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComposite");
        ConstructorDescription constructorDescription = (ConstructorDescription)description.getConstructors().get(0);
        ParameterDescription parameter_0 = constructorDescription.getParameter(0);
        DescriptionProcessorTest.assertTrue((boolean)parameter_0.isParent());
        ParameterDescription styleParameter = constructorDescription.getParameter(1);
        DescriptionProcessorTest.assertInstanceOf(StylePropertyEditor.class, (Object)styleParameter.getEditor());
    }

    @Test
    public void test_decriptionForCustomComponent_onlyParent() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent) {", "    super(parent, SWT.NONE);", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ComponentDescription description = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComposite");
        ConstructorDescription constructorDescription = (ConstructorDescription)description.getConstructors().get(0);
        ParameterDescription parameter_0 = constructorDescription.getParameter(0);
        DescriptionProcessorTest.assertTrue((boolean)parameter_0.isParent());
    }

    @Test
    public void test_decriptionForCustomComponent_1() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new MyComposite(this, SWT.NONE);", "  }", "}");
        ControlInfo custom = (ControlInfo)shell.getChildrenControls().get(0);
        ComponentDescription description = custom.getDescription();
        ConstructorDescription constructorDescription = (ConstructorDescription)description.getConstructors().get(0);
        DescriptionProcessorTest.assertTrue((boolean)constructorDescription.getParameter(0).isParent());
        ParameterDescription styleParameter = constructorDescription.getParameter(1);
        StylePropertyEditor editor = (StylePropertyEditor)styleParameter.getEditor();
        DescriptionProcessorTest.assertEquals((Object)"org.eclipse.swt.SWT", (Object)ReflectionUtils.getFieldObject((Object)editor, (String)"m_className"));
        DescriptionProcessorTest.assertEquals((Object)"org.eclipse.swt.SWT.NONE", (Object)styleParameter.getDefaultSource());
    }

    @Test
    public void test_decriptionForCustomComponent_2() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.wbp-component.xml", DescriptionProcessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='org.eclipse.swt.widgets.Composite'/>", "      <parameter type='int' defaultSource='org.eclipse.swt.SWT.BORDER'>", "        <editor id='style'>", "          <parameter name='class'>org.eclipse.swt.SWT</parameter>", "          <parameter name='set'>BORDER</parameter>", "        </editor>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite2.java", this.getTestSource("public class MyComposite2 extends MyComposite {", "  public MyComposite2(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new MyComposite2(this, SWT.NONE);", "  }", "}");
        ControlInfo composite = (ControlInfo)shell.getChildrenControls().get(0);
        ComponentDescription description = composite.getDescription();
        ConstructorDescription constructorDescription = (ConstructorDescription)description.getConstructors().get(0);
        ParameterDescription styleParameter = constructorDescription.getParameter(1);
        DescriptionProcessorTest.assertEquals((Object)"org.eclipse.swt.SWT.BORDER", (Object)styleParameter.getDefaultSource());
    }

    @Test
    public void test_noStyleProperty_whenDisplayExpressionEditor() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.wbp-component.xml", DescriptionProcessorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='org.eclipse.swt.widgets.Composite'/>", "      <parameter type='int'>", "        <editor id='displayExpression'/>", "      </parameter>", "    </constructor>", "  </constructors>", "</component>"));
        DescriptionProcessorTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new MyComposite(this, SWT.NONE);", "  }", "}");
        ControlInfo composite = (ControlInfo)shell.getChildrenControls().get(0);
        ComponentDescription description = composite.getDescription();
        ConstructorDescription constructorDescription = (ConstructorDescription)description.getConstructors().get(0);
        ParameterDescription styleParameter = constructorDescription.getParameter(1);
        DescriptionProcessorTest.assertSame((Object)DisplayExpressionPropertyEditor.INSTANCE, (Object)styleParameter.getEditor());
        DescriptionProcessorTest.assertNull((Object)composite.getPropertyByTitle("Style"));
    }

    @Test
    public void test_forInterface() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyInterface.java", DescriptionProcessorTest.getSource("package test;", "public interface MyInterface {", "  // filler", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        Class<?> myInterface = this.m_lastLoader.loadClass("test.MyInterface");
        ComponentDescription componentDescription = new ComponentDescription(new ComponentDescriptionKey(myInterface));
        DescriptionProcessor.INSTANCE.process(this.m_lastEditor, componentDescription);
    }

    @Test
    public void test_defaultCreation_onlyParent() throws Exception {
        String additionalParameters = "";
        String source = "new test.MyComposite(%parent%)";
        this.check_defaultCreation(additionalParameters, source);
    }

    @Test
    public void test_defaultCreation_parentStyle() throws Exception {
        String additionalParameters = ", int style";
        String source = "new test.MyComposite(%parent%, org.eclipse.swt.SWT.NONE)";
        this.check_defaultCreation(additionalParameters, source);
    }

    @Test
    public void test_defaultCreation_secondBoolean() throws Exception {
        String additionalParameters = ", boolean a";
        String source = "new test.MyComposite(%parent%, false)";
        this.check_defaultCreation(additionalParameters, source);
    }

    @Test
    public void test_defaultCreation_secondDouble() throws Exception {
        String additionalParameters = ", double a";
        String source = "new test.MyComposite(%parent%, 0.0)";
        this.check_defaultCreation(additionalParameters, source);
    }

    @Test
    public void test_defaultCreation_secondObject() throws Exception {
        String additionalParameters = ", Object a";
        String source = "new test.MyComposite(%parent%, (java.lang.Object) null)";
        this.check_defaultCreation(additionalParameters, source);
    }

    private void check_defaultCreation(String additionalParameters, String expected) throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent" + additionalParameters + ") {", "    super(parent, SWT.NONE);", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComposite");
        CreationDescription creationDescription = componentDescription.getCreation(null);
        DescriptionProcessorTest.assertEquals((Object)expected, (Object)creationDescription.getSource());
    }

    @Test
    public void test_styleBeanInfo() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        DescriptionProcessorTest.setFileContentSrc("test/MyCompositeBeanInfo.java", DescriptionProcessorTest.getSourceDQ("package test;", "import java.beans.*;", "public class MyCompositeBeanInfo extends SimpleBeanInfo {", "  private static final String SWT_STYLE = 'org.eclipse.wb.swt.style';", "  public BeanDescriptor getBeanDescriptor() {", "    BeanDescriptor luo_descriptor = new BeanDescriptor( MyComposite.class );", "    luo_descriptor.setValue(SWT_STYLE, new String[][]{", "      new String[]{'set', null, 'border', 'flat'},", "      new String[]{'select', 'type', 'push', null, 'push', 'check', 'radio'},", "    });", "    return luo_descriptor;", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription((AstEditor)this.m_lastEditor, (String)"test.MyComposite");
        ConstructorDescription constructor = (ConstructorDescription)componentDescription.getConstructors().get(0);
        ParameterDescription parameter = constructor.getParameter(0);
        DescriptionProcessorTest.assertTrue((boolean)parameter.isParent());
        parameter = constructor.getParameter(1);
        DescriptionProcessorTest.assertSame(Integer.TYPE, (Object)parameter.getType());
        StylePropertyEditor editor = (StylePropertyEditor)parameter.getEditor();
        DescriptionProcessorTest.assertEquals((Object)DescriptionProcessorTest.getSource("org.eclipse.swt.SWT", "  border boolean: BORDER", "  flat boolean: FLAT", "  type select: 0 PUSH CHECK RADIO"), (Object)editor.getAsString());
    }

    @Test
    public void test_executeCreateMethods() throws Exception {
        DescriptionProcessorTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "  public void createFoo(Composite parent) {", "    setEnabled(false);", "  }", "}"));
        DescriptionProcessorTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    createFoo(this);", "  }", "}");
        composite.refresh();
        DescriptionProcessorTest.assertEquals((Object)false, (Object)composite.getWidget().isEnabled());
    }
}

