/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageDescriptorPropertyEditor;
import org.eclipse.wb.tests.designer.swt.model.property.ImageDescriptorPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ImageDescriptorPropertyEditorTestWithManager
extends ImageDescriptorPropertyEditorTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", true);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_noValue() throws Exception {
        GenericPropertyNoValue property = new GenericPropertyNoValue(null, null, ImageDescriptorPropertyEditor.INSTANCE);
        ImageDescriptorPropertyEditorTestWithManager.assertNull((Object)PropertyEditorTestUtils.getText((Property)property));
        ImageDescriptorPropertyEditorTestWithManager.assertNull((Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    @Test
    public void test_textSource_nullValue() throws Exception {
        this.assert_getText_getClipboardSource_forSource("null", "(null)", "null");
    }

    @Test
    public void test_textSource_absolutePath() throws Exception {
        File file = ImageDescriptorPropertyEditorTestWithManager.createTempImage();
        try {
            String path = FilenameUtils.separatorsToUnix((String)file.getCanonicalPath());
            this.assert_getText_getClipboardSource_forSource(ImageDescriptorPropertyEditor.getInvocationSource(null, (String)("\"" + path + "\"")), "File: " + path, ImageDescriptorPropertyEditor.getInvocationSource(null, (String)("\"" + path + "\"")));
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void test_textSource_image_over_classpath() throws Exception {
        this.assert_getText_getClipboardSource_forSource(ImageDescriptorPropertyEditor.getInvocationSource((String)"getClass()", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""), "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImageDescriptorPropertyEditor.getInvocationSource((String)"{wbp_classTop}", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
    }

    @Test
    public void test_textSource_image_over_classpath_OtherClass() throws Exception {
        this.assert_getText_getClipboardSource_forSource(ImageDescriptorPropertyEditor.getInvocationSource((String)"String.class", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""), "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImageDescriptorPropertyEditor.getInvocationSource((String)"{wbp_classTop}", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
    }

    @Test
    public void test_textSource_absolutePath2() throws Exception {
        File file = ImageDescriptorPropertyEditorTestWithManager.createTempImage();
        try {
            String path = FilenameUtils.separatorsToUnix((String)file.getCanonicalPath());
            this.assert_getText_getClipboardSource_forSource(ImageDescriptorPropertyEditor.getInvocationSource(null, (String)("\"" + path + "\"")), "File: " + path, ImageDescriptorPropertyEditor.getInvocationSource(null, (String)("\"" + path + "\"")));
        }
        finally {
            file.delete();
        }
    }

    @Test
    public void test_textSource_image_over_classpath2() throws Exception {
        this.assert_getText_getClipboardSource_forSource(ImageDescriptorPropertyEditor.getInvocationSource((String)"getClass()", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""), "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImageDescriptorPropertyEditor.getInvocationSource((String)"{wbp_classTop}", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
    }

    @Test
    public void test_textSource_image_over_classpath_OtherClass2() throws Exception {
        this.assert_getText_getClipboardSource_forSource(ImageDescriptorPropertyEditor.getInvocationSource((String)"String.class", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""), "Classpath: /javax/swing/plaf/basic/icons/JavaCup16.png", ImageDescriptorPropertyEditor.getInvocationSource((String)"{wbp_classTop}", (String)"\"/javax/swing/plaf/basic/icons/JavaCup16.png\""));
    }
}

