/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util.generic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ModelMethodPropertyChildTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    private void prepareMyPanel(String parameters) throws Exception {
        ModelMethodPropertyChildTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  // filler", "}"));
        ModelMethodPropertyChildTest.setFileContentSrc("test/MyPanel.wbp-component.xml", ModelMethodPropertyChildTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <model class='" + MyModel.class.getName() + "'/>", "  <parameters>", "    <parameter name='modelMethodChildProperty " + parameters + "'/>", "  </parameters>", "</component>"));
        ModelMethodPropertyChildTest.waitForAutoBuild();
    }

    @Test
    public void test_valueProperty() throws Exception {
        this.prepareMyPanel("getter=getValue setter=setValue title=value category=normal type=java.lang.String child=" + ComponentInfo.class.getName());
        ContainerInfo panel = this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    add(new JButton());", "    add(new JTextField());", "  }", "}");
        panel.refresh();
        ModelMethodPropertyChildTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo text = (ComponentInfo)panel.getChildrenComponents().get(1);
        Property property = button.getPropertyByTitle("value");
        ModelMethodPropertyChildTest.assertNotNull((Object)property);
        ModelMethodPropertyChildTest.assertSame((Object)PropertyCategory.NORMAL, (Object)property.getCategory());
        ModelMethodPropertyChildTest.assertSame((Object)StringPropertyEditor.INSTANCE, (Object)property.getEditor());
        ModelMethodPropertyChildTest.assertFalse((boolean)property.isModified());
        ModelMethodPropertyChildTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        property.setValue((Object)"123");
        ModelMethodPropertyChildTest.assertEquals((Object)"123", (Object)property.getValue());
        ModelMethodPropertyChildTest.assertSame((Object)property, (Object)button.getPropertyByTitle("value"));
        property = text.getPropertyByTitle("value");
        ModelMethodPropertyChildTest.assertNotNull((Object)property);
        ModelMethodPropertyChildTest.assertSame((Object)PropertyCategory.NORMAL, (Object)property.getCategory());
        ModelMethodPropertyChildTest.assertFalse((boolean)property.isModified());
        ModelMethodPropertyChildTest.assertSame((Object)Property.UNKNOWN_VALUE, (Object)property.getValue());
        property.setValue((Object)"123");
        ModelMethodPropertyChildTest.assertEquals((Object)"123", (Object)property.getValue());
        ModelMethodPropertyChildTest.assertSame((Object)property, (Object)text.getPropertyByTitle("value"));
        ModelMethodPropertyChildTest.assertNotSame((Object)property, (Object)button.getPropertyByTitle("value"));
        property = panel.getLayout().getPropertyByTitle("value");
        ModelMethodPropertyChildTest.assertNull((Object)property);
    }

    @Test
    public void test_noRequiredParameters() throws Exception {
        this.prepareMyPanel("");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"'getter'"})).contains(new CharSequence[]{"'setter'"})).contains(new CharSequence[]{"'title'"});
    }

    @Test
    public void test_noParameter_getter() throws Exception {
        this.prepareMyPanel("getter=noSuchMethod setter=foo title=bar type=java.lang.String");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"Invalid"})).contains(new CharSequence[]{"getter"});
    }

    @Test
    public void test_noParameter_setter() throws Exception {
        this.prepareMyPanel("getter=getValue setter=noSuchMethod title=bar type=java.lang.String");
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        List warnings = this.m_lastState.getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        ((AbstractStringAssert)Assertions.assertThat((String)((EditorWarning)warnings.get(0)).getMessage()).contains(new CharSequence[]{"Invalid"})).contains(new CharSequence[]{"setter"});
    }

    public static class MyModel
    extends ContainerInfo {
        private final Map<Object, String> m_values = new HashMap<Object, String>();

        public MyModel(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
        }

        public Object getValue(ComponentInfo component) {
            String value = this.m_values.get(component);
            return value != null ? value : Property.UNKNOWN_VALUE;
        }

        public void setValue(ComponentInfo component, Object value) {
            this.m_values.put(component, (String)value);
        }
    }
}

