/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.EditorActivatedListener;
import org.eclipse.wb.core.model.broadcast.EditorActivatedRequest;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.jupiter.api.Test;

public class ReparseOnModificationTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_modifyComponent_whenDesign() throws Exception {
        ICompilationUnit componentUnit = this.createModelCompilationUnit("test", "MyComponent.java", this.getTestSource("public class MyComponent extends JPanel {\n\tpublic MyComponent() {\n\t}\n}"));
        ReparseOnModificationTest.waitForAutoBuild();
        ContainerInfo initialPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tadd(new MyComponent());\n\t}\n}");
        IEditorPart componentEditor = JavaUI.openInEditor((IJavaElement)componentUnit);
        componentUnit.getBuffer().replace(0, 0, "// comment\n");
        componentEditor.doSave(null);
        ICompilationUnit unit = initialPanel.getEditor().getModelUnit();
        JavaUI.openInEditor((IJavaElement)unit);
        ReparseOnModificationTest.waitEventLoop(0);
        this.fetchContentFields();
        ReparseOnModificationTest.assertNotSame((Object)initialPanel, (Object)this.m_contentJavaInfo);
    }

    @Test
    public void test_modifyComponent_whenSource() throws Exception {
        ICompilationUnit componentUnit = this.createModelCompilationUnit("test", "MyComponent.java", this.getTestSource("public class MyComponent extends JPanel {\n\tpublic MyComponent() {\n\t}\n}"));
        ReparseOnModificationTest.waitForAutoBuild();
        ContainerInfo initialPanel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tadd(new MyComponent());\n\t}\n}");
        this.openSourcePage();
        IEditorPart componentEditor = JavaUI.openInEditor((IJavaElement)componentUnit);
        componentUnit.getBuffer().replace(0, 0, "// comment\n");
        componentEditor.doSave(null);
        ICompilationUnit unit = initialPanel.getEditor().getModelUnit();
        JavaUI.openInEditor((IJavaElement)unit);
        this.fetchContentFields();
        ReparseOnModificationTest.assertSame((Object)initialPanel, (Object)this.m_contentJavaInfo);
        this.openDesignPage();
        this.fetchContentFields();
        ReparseOnModificationTest.assertNotSame((Object)initialPanel, (Object)this.m_contentJavaInfo);
    }

    @Test
    public void test_modifyComponent_direct() throws Exception {
        ICompilationUnit myComponentUnit = this.createModelCompilationUnit("test", "MyComponent.java", this.getTestSource("public class MyComponent extends JPanel {\n\tpublic MyComponent() {\n\t}\n}"));
        ReparseOnModificationTest.waitForAutoBuild();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tadd(new MyComponent());\n\t}\n}");
        ReparseOnModificationTest.assertFalse((boolean)ReparseOnModificationTest.shouldReparse_editorActivated((JavaInfo)panel));
        myComponentUnit.getBuffer().replace(0, 0, "// comment\n");
        myComponentUnit.save(null, true);
        ReparseOnModificationTest.assertTrue((boolean)ReparseOnModificationTest.shouldReparse_editorActivated((JavaInfo)panel));
    }

    @Test
    public void test_modifyComponent_secondLevel() throws Exception {
        ICompilationUnit myComponentInnerUnit = this.createModelCompilationUnit("test", "MyComponent_inner.java", this.getTestSource("public class MyComponent_inner extends JPanel {\n\tpublic MyComponent_inner() {\n\t}\n}"));
        ReparseOnModificationTest.setFileContentSrc("test/MyComponent.java", this.getTestSource("public class MyComponent extends JPanel {\n\tpublic MyComponent() {\n\t\tadd(new MyComponent_inner());\n\t}\n}"));
        ReparseOnModificationTest.waitForAutoBuild();
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tadd(new MyComponent());\n\t}\n}");
        ReparseOnModificationTest.assertFalse((boolean)ReparseOnModificationTest.shouldReparse_editorActivated((JavaInfo)panel));
        myComponentInnerUnit.getBuffer().replace(0, 0, "// comment\n");
        myComponentInnerUnit.save(null, true);
        ReparseOnModificationTest.assertTrue((boolean)ReparseOnModificationTest.shouldReparse_editorActivated((JavaInfo)panel));
    }

    @Override
    protected ContainerInfo openContainer(String lines) throws Exception {
        ContainerInfo container = super.openContainer(lines);
        ReparseOnModificationTest.waitDependencyInformation(container);
        return container;
    }

    private static void waitDependencyInformation(ContainerInfo container) throws Exception {
        int i = 0;
        while (i < 100) {
            if (JavaInfoUtils.hasDependencyInformation((JavaInfo)container)) break;
            Thread.sleep(10L);
            ++i;
        }
    }

    private static boolean shouldReparse_editorActivated(JavaInfo panel) throws Exception {
        EditorActivatedRequest request = new EditorActivatedRequest();
        ((EditorActivatedListener)panel.getBroadcast(EditorActivatedListener.class)).invoke(request);
        return request.isReparseRequested();
    }
}

