/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.widgets.timegraph.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NonNullByDefault
public class StyleManagerTest {
    private static final String STYLE1 = "style1";
    private static final String STYLE2 = "style2";
    private static final String RED_COLOR = Objects.requireNonNull(X11ColorUtils.toHexColor((String)"red"));
    private static final String BLUE_COLOR = Objects.requireNonNull(X11ColorUtils.toHexColor((String)"blue"));
    private static final String BLACK_COLOR = Objects.requireNonNull(X11ColorUtils.toHexColor((String)"black"));
    private static StyleTestCase DISJOINT_STYLES = new StyleTestCase((Map)ImmutableMap.of((Object)"style1", (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)"style1", (Object)"background-color", (Object)RED_COLOR, (Object)"height", (Object)Float.valueOf(1.0f), (Object)"opacity", (Object)Float.valueOf(1.0f))), (Object)"style2", (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)"style2", (Object)"background-color", (Object)BLUE_COLOR, (Object)"height", (Object)Float.valueOf(0.5f), (Object)"opacity", (Object)Float.valueOf(0.5f))))){

        @Override
        public List<StyleProperty> getStylePropertiesToTest() {
            return ImmutableList.of((Object)new StyleProperty(new OutputElementStyle(StyleManagerTest.STYLE1), "style-name", StyleManagerTest.STYLE1), (Object)new StyleProperty(new OutputElementStyle(StyleManagerTest.STYLE2), "style-name", StyleManagerTest.STYLE2));
        }

        @Override
        public List<StyleProperty> getFactorStylePropertiesToTest() {
            return ImmutableList.of((Object)new StyleProperty(new OutputElementStyle(StyleManagerTest.STYLE1), "height", Float.valueOf(1.0f)), (Object)new StyleProperty(new OutputElementStyle(StyleManagerTest.STYLE2), "height", Float.valueOf(0.5f)));
        }

        @Override
        public List<StyleProperty> getColorStylePropertiesToTest() {
            return ImmutableList.of((Object)new StyleProperty(new OutputElementStyle(StyleManagerTest.STYLE1), "background-color", RGBAColor.fromString((String)RED_COLOR, (int)255)), (Object)new StyleProperty(new OutputElementStyle(StyleManagerTest.STYLE2), "background-color", RGBAColor.fromString((String)BLUE_COLOR, (int)127)));
        }
    };
    private static final OutputElementStyle STYLE_WITH_MAP = new OutputElementStyle("style1", (Map)ImmutableMap.of((Object)"style-name", (Object)"style2", (Object)"background-color", (Object)BLUE_COLOR, (Object)"height", (Object)Float.valueOf(0.5f), (Object)"color", (Object)RED_COLOR));
    private static StyleTestCase STYLES_WITH_MAP = new StyleTestCase((Map)ImmutableMap.of((Object)"style1", (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)"style1", (Object)"background-color", (Object)RED_COLOR, (Object)"height", (Object)Float.valueOf(0.75f), (Object)"opacity", (Object)Float.valueOf(0.5f))))){

        @Override
        public List<StyleProperty> getStylePropertiesToTest() {
            return ImmutableList.of((Object)new StyleProperty(STYLE_WITH_MAP, "style-name", StyleManagerTest.STYLE2));
        }

        @Override
        public List<StyleProperty> getFactorStylePropertiesToTest() {
            return ImmutableList.of((Object)new StyleProperty(STYLE_WITH_MAP, "height", Float.valueOf(0.5f)));
        }

        @Override
        public List<StyleProperty> getColorStylePropertiesToTest() {
            return ImmutableList.of((Object)new StyleProperty(STYLE_WITH_MAP, "background-color", RGBAColor.fromString((String)BLUE_COLOR, (int)127)), (Object)new StyleProperty(STYLE_WITH_MAP, "color", RGBAColor.fromString((String)RED_COLOR, (int)127)));
        }
    };
    private static final Map<String, Object> STYLE1_PROPERTIES;
    private static final OutputElementStyle INHERITING_STYLE;
    private static final OutputElementStyle BASE_STYLE;
    private static StyleTestCase STYLE_INHERITANCE;
    private static final OutputElementStyle EMPTY_STYLE;
    private static StyleTestCase DEFAULT_VALUES;
    private static final OutputElementStyle A_THEN_B_STYLE;
    private static final OutputElementStyle B_THEN_A_STYLE;
    private static final OutputElementStyle B_THEN_A_STYLE_THEN_MAP;
    private static StyleTestCase MULTIPLE_INHERITANCE;
    private StyleTestCase fTestCase;
    private StyleManager fManager;

    static {
        INHERITING_STYLE = new OutputElementStyle(STYLE2);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"border-style", (Object)"dashed");
        builder.put((Object)"direction", (Object)"ltr");
        builder.put((Object)"height", (Object)Float.valueOf(0.75f));
        builder.put((Object)"opacity", (Object)Float.valueOf(0.75f));
        builder.put((Object)"background-color", (Object)RED_COLOR);
        builder.put((Object)"color", (Object)BLUE_COLOR);
        STYLE1_PROPERTIES = builder.build();
        BASE_STYLE = new OutputElementStyle(STYLE1);
        STYLE_INHERITANCE = new StyleTestCase((Map)ImmutableMap.of((Object)STYLE1, (Object)new OutputElementStyle(null, STYLE1_PROPERTIES), (Object)STYLE2, (Object)new OutputElementStyle(STYLE1, (Map)ImmutableMap.of((Object)"direction", (Object)"rtl", (Object)"color", (Object)RED_COLOR, (Object)"opacity", (Object)Float.valueOf(0.5f), (Object)"height-factor", (Object)Float.valueOf(0.5f), (Object)"background-color-blend", (Object)(BLUE_COLOR + String.format("%02X", 127)))))){

            @Override
            public List<StyleProperty> getStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(INHERITING_STYLE, "border-style", "dashed"), (Object)new StyleProperty(INHERITING_STYLE, "direction", "rtl"));
            }

            @Override
            public List<StyleProperty> getFactorStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(INHERITING_STYLE, "height", Float.valueOf(0.375f)), (Object)new StyleProperty(INHERITING_STYLE, "opacity", Float.valueOf(0.5f)));
            }

            @Override
            public List<StyleProperty> getColorStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(INHERITING_STYLE, "background-color", new RGBAColor(85, 0, 169, 191)), (Object)new StyleProperty(BASE_STYLE, "background-color", RGBAColor.fromString((String)RED_COLOR, (int)191)), (Object)new StyleProperty(INHERITING_STYLE, "color", RGBAColor.fromString((String)RED_COLOR, (int)127)));
            }
        };
        EMPTY_STYLE = new OutputElementStyle(null, Collections.emptyMap());
        DEFAULT_VALUES = new StyleTestCase(Collections.emptyMap()){

            @Override
            public List<StyleProperty> getStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(EMPTY_STYLE, "linear-gradient", null), (Object)new StyleProperty(EMPTY_STYLE, "linear-gradient-direction", null), (Object)new StyleProperty(EMPTY_STYLE, "direction", null), (Object)new StyleProperty(EMPTY_STYLE, "text-align", null), (Object)new StyleProperty(EMPTY_STYLE, "font-style", null), (Object)new StyleProperty(EMPTY_STYLE, "font-weight", null), (Object)new StyleProperty(EMPTY_STYLE, "symbol-type", null), (Object)new StyleProperty(EMPTY_STYLE, "border-style", null));
            }

            @Override
            public List<StyleProperty> getFactorStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(EMPTY_STYLE, "height", null), (Object)new StyleProperty(EMPTY_STYLE, "width", null), (Object)new StyleProperty(EMPTY_STYLE, "border-radius", null), (Object)new StyleProperty(EMPTY_STYLE, "opacity", null));
            }

            @Override
            public List<StyleProperty> getColorStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(EMPTY_STYLE, "background-color", null), (Object)new StyleProperty(EMPTY_STYLE, "linear-gradient-color-end", null), (Object)new StyleProperty(EMPTY_STYLE, "border-color", null), (Object)new StyleProperty(EMPTY_STYLE, "color", null));
            }
        };
        A_THEN_B_STYLE = new OutputElementStyle("B2,A2");
        B_THEN_A_STYLE = new OutputElementStyle("A2,B2");
        B_THEN_A_STYLE_THEN_MAP = new OutputElementStyle("A2,B2", (Map)ImmutableMap.of((Object)"symbol-type", (Object)"plus", (Object)"border-radius", (Object)Float.valueOf(0.25f), (Object)"color", (Object)BLACK_COLOR));
        MULTIPLE_INHERITANCE = new StyleTestCase((Map)ImmutableMap.of((Object)"A1", (Object)new OutputElementStyle("A", (Map)ImmutableMap.of((Object)"background-color", (Object)RED_COLOR, (Object)"opacity", (Object)Float.valueOf(0.5f), (Object)"symbol-type", (Object)"circle")), (Object)"A2", (Object)new OutputElementStyle("A1", (Map)ImmutableMap.of((Object)"background-color", (Object)BLUE_COLOR, (Object)"border-radius", (Object)Float.valueOf(0.75f), (Object)"color", (Object)RED_COLOR)), (Object)"B1", (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"height", (Object)Float.valueOf(0.75f), (Object)"width", (Object)2, (Object)"symbol-type", (Object)"diamond", (Object)"color", (Object)BLUE_COLOR)), (Object)"B2", (Object)new OutputElementStyle("B1", (Map)ImmutableMap.of((Object)"height", (Object)Float.valueOf(0.5f), (Object)"border-radius", (Object)Float.valueOf(0.5f))))){

            @Override
            public List<StyleProperty> getStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(A_THEN_B_STYLE, "symbol-type", "circle"), (Object)new StyleProperty(B_THEN_A_STYLE, "symbol-type", "diamond"), (Object)new StyleProperty(B_THEN_A_STYLE_THEN_MAP, "symbol-type", "plus"));
            }

            @Override
            public List<StyleProperty> getFactorStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(A_THEN_B_STYLE, "height", Float.valueOf(0.5f)), (Object)new StyleProperty(B_THEN_A_STYLE, "height", Float.valueOf(0.5f)), (Object)new StyleProperty(A_THEN_B_STYLE, "width", Float.valueOf(2.0f)), (Object)new StyleProperty(B_THEN_A_STYLE, "width", Float.valueOf(2.0f)), (Object)new StyleProperty(A_THEN_B_STYLE, "border-radius", Float.valueOf(0.75f)), (Object)new StyleProperty(B_THEN_A_STYLE, "border-radius", Float.valueOf(0.5f)), (Object)new StyleProperty(B_THEN_A_STYLE_THEN_MAP, "border-radius", Float.valueOf(0.25f)));
            }

            @Override
            public List<StyleProperty> getColorStylePropertiesToTest() {
                return ImmutableList.of((Object)new StyleProperty(A_THEN_B_STYLE, "background-color", RGBAColor.fromString((String)BLUE_COLOR, (int)127)), (Object)new StyleProperty(B_THEN_A_STYLE, "background-color", RGBAColor.fromString((String)BLUE_COLOR, (int)127)), (Object)new StyleProperty(A_THEN_B_STYLE, "color", RGBAColor.fromString((String)RED_COLOR, (int)127)), (Object)new StyleProperty(B_THEN_A_STYLE, "color", RGBAColor.fromString((String)BLUE_COLOR, (int)127)), (Object)new StyleProperty(B_THEN_A_STYLE_THEN_MAP, "color", RGBAColor.fromString((String)BLACK_COLOR, (int)127)));
            }
        };
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"disjoint styles", DISJOINT_STYLES}, {"styles with map", STYLES_WITH_MAP}, {"style inheritance", STYLE_INHERITANCE}, {"default values", DEFAULT_VALUES}, {"multiple inheritance", MULTIPLE_INHERITANCE});
    }

    public StyleManagerTest(String testCaseName, StyleTestCase testCase) {
        this.fTestCase = testCase;
        this.fManager = new StyleManager(this.fTestCase.getStyleMap());
    }

    @Test
    public void testStyleProperties() {
        for (StyleProperty property : this.fTestCase.getStylePropertiesToTest()) {
            Object value = this.fManager.getStyle(property.fStyle, property.fPropertyName);
            if (property.fResult == null) {
                Assert.assertNull((String)(property.fStyle.getParentKey() + "," + property.fPropertyName), (Object)value);
                continue;
            }
            Assert.assertEquals((String)(property.fStyle.getParentKey() + "," + property.fPropertyName), (Object)property.fResult, (Object)value);
        }
    }

    @Test
    public void testFactorStyleProperties() {
        for (StyleProperty property : this.fTestCase.getFactorStylePropertiesToTest()) {
            Float value = this.fManager.getFactorStyle(property.fStyle, property.fPropertyName);
            if (property.fResult == null) {
                Assert.assertNull((String)(property.fStyle.getParentKey() + "," + property.fPropertyName), (Object)value);
                continue;
            }
            Assert.assertEquals((String)(property.fStyle.getParentKey() + "," + property.fPropertyName), (Object)property.fResult, (Object)value);
        }
    }

    @Test
    public void testColorStyleProperties() {
        for (StyleProperty property : this.fTestCase.getColorStylePropertiesToTest()) {
            RGBAColor value = this.fManager.getColorStyle(property.fStyle, property.fPropertyName);
            if (property.fResult == null) {
                Assert.assertNull((String)(property.fStyle.getParentKey() + "," + property.fPropertyName), (Object)value);
                continue;
            }
            Assert.assertEquals((String)(property.fStyle.getParentKey() + "," + property.fPropertyName), (Object)property.fResult, (Object)value);
        }
    }

    private static class StyleProperty {
        private OutputElementStyle fStyle;
        private String fPropertyName;
        private @Nullable Object fResult;

        public StyleProperty(OutputElementStyle style, String propertyName, @Nullable Object result) {
            this.fPropertyName = propertyName;
            this.fResult = result;
            this.fStyle = style;
        }
    }

    private static class StyleTestCase {
        private Map<String, OutputElementStyle> fStyleMap;

        public StyleTestCase(Map<String, OutputElementStyle> styleMap) {
            this.fStyleMap = styleMap;
        }

        public Map<String, OutputElementStyle> getStyleMap() {
            return this.fStyleMap;
        }

        public List<StyleProperty> getStylePropertiesToTest() {
            return Collections.emptyList();
        }

        public List<StyleProperty> getFactorStylePropertiesToTest() {
            return Collections.emptyList();
        }

        public List<StyleProperty> getColorStylePropertiesToTest() {
            return Collections.emptyList();
        }
    }
}

