/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views;

import java.util.Arrays;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.tests.stubs.views.TmfViewStub;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class TmfViewFactoryTest {
    private static final String SEPARATOR = "&";
    private static final String UUID = "90148656-2bd7-4f3e-8513-4def0ac76b1f";
    BaseSecIdTestCase[] baseSecIdTestCases = new BaseSecIdTestCase[]{new BaseSecIdTestCase(null, null), new BaseSecIdTestCase("90148656-2bd7-4f3e-8513-4def0ac76b1f", null), new BaseSecIdTestCase("&90148656-2bd7-4f3e-8513-4def0ac76b1f", ""), new BaseSecIdTestCase("&1-1-1-1-1", "&1-1-1-1-1"), new BaseSecIdTestCase("sec_id", "sec_id"), new BaseSecIdTestCase("sec_id&", "sec_id&"), new BaseSecIdTestCase("sec_id&90148656-2bd7-4f3e-8513-4def0ac76b1f", "sec_id"), new BaseSecIdTestCase("sec_id&&90148656-2bd7-4f3e-8513-4def0ac76b1f", "sec_id&"), new BaseSecIdTestCase("sec_id&third_id", "sec_id&third_id"), new BaseSecIdTestCase("sec_id&third_id&90148656-2bd7-4f3e-8513-4def0ac76b1f", "sec_id&third_id"), new BaseSecIdTestCase("sec_id&third_id&fourth_id", "sec_id&third_id&fourth_id")};

    @Test
    public void testGetBaseSecId() {
        BaseSecIdTestCase[] baseSecIdTestCaseArray = this.baseSecIdTestCases;
        int n = this.baseSecIdTestCases.length;
        int n2 = 0;
        while (n2 < n) {
            BaseSecIdTestCase testCase = baseSecIdTestCaseArray[n2];
            String input = testCase.getInput();
            String expect = testCase.getOutput();
            String result = TmfViewFactory.getBaseSecId((String)input);
            String message = String.format("Input:%s Output: %s Expected: %s", input, result, expect);
            Assert.assertEquals((String)message, (Object)expect, (Object)result);
            ++n2;
        }
    }

    @Test
    public void testNewView() {
        IViewPart firstView = TmfViewFactory.newView((String)((String)NonNullUtils.checkNotNull((Object)TmfViewStub.TMF_VIEW_STUB_ID)), (boolean)false);
        IViewPart sameAsFirstView = TmfViewFactory.newView((String)((String)NonNullUtils.checkNotNull((Object)TmfViewStub.TMF_VIEW_STUB_ID)), (boolean)false);
        IViewPart secondView = TmfViewFactory.newView((String)((String)NonNullUtils.checkNotNull((Object)TmfViewStub.TMF_VIEW_STUB_ID)), (boolean)true);
        IViewPart failView1 = TmfViewFactory.newView((String)"this.is.a.failing.view.id", (boolean)false);
        IViewPart failView2 = TmfViewFactory.newView((String)"this.is.a.failing.view.id", (boolean)true);
        Assert.assertNotNull((String)"Failed to spawn first view", (Object)firstView);
        Assert.assertEquals((String)"Same id returned different instance", (Object)sameAsFirstView, (Object)firstView);
        Assert.assertNotNull((String)"Failed to open second view with suffix", (Object)secondView);
        Assert.assertNull((String)"Expected to fail on dummy view id", (Object)failView1);
        Assert.assertNull((String)"Expected to fail on dummy view id with suffix", (Object)failView2);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IViewReference[] viewRefs = page.getViewReferences();
        String fullId = null;
        IViewReference[] iViewReferenceArray = viewRefs;
        int n = viewRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            if (view.getSecondaryId() != null && view.getId().equals(TmfViewStub.TMF_VIEW_STUB_ID)) {
                Assert.assertTrue((String)"Instanceof a TmfViewStub", (boolean)(view.getView(false) instanceof TmfViewStub));
                fullId = ((TmfViewStub)view.getView(false)).getViewId();
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(fullId);
        IViewPart thirdView = TmfViewFactory.newView(fullId, (boolean)true);
        Assert.assertNotNull((String)"Creation from a view id with suffix failed", fullId);
        Assert.assertFalse((String)"New view from view id with suffix was not created", (boolean)Arrays.asList(viewRefs).contains(thirdView));
    }

    private static class BaseSecIdTestCase {
        private String input;
        private String output;

        public BaseSecIdTestCase(String input, String secondaryId) {
            this.input = input;
            this.output = secondaryId;
        }

        public String getInput() {
            return this.input;
        }

        public String getOutput() {
            return this.output;
        }
    }
}

