/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.viewers;

import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.junit.Assert;
import org.junit.Test;

public class ToolTipStringTest {
    @Test
    public void testDecimal() {
        TmfAbstractToolTipHandler.ToolTipString fromFloat = TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)Float.valueOf(1.0f));
        TmfAbstractToolTipHandler.ToolTipString fromDouble = TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)1.0);
        TmfAbstractToolTipHandler.ToolTipString fromInt = TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)1);
        TmfAbstractToolTipHandler.ToolTipString fromLong = TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)1L);
        Assert.assertEquals((Object)"1", (Object)fromFloat.toString());
        Assert.assertEquals((Object)"1", (Object)fromDouble.toString());
        Assert.assertEquals((Object)"1", (Object)fromInt.toString());
        Assert.assertEquals((Object)"1", (Object)fromLong.toString());
        Assert.assertEquals((Object)"1", (Object)fromFloat.toHtmlString());
        Assert.assertEquals((Object)"1", (Object)fromDouble.toHtmlString());
        Assert.assertEquals((Object)"1", (Object)fromInt.toHtmlString());
        Assert.assertEquals((Object)"1", (Object)fromLong.toHtmlString());
    }

    @Test
    public void testHtml() {
        String simple = "<head></head>";
        String normal = "<a href=\"www.tracecompass.org\">Trace Compass</a>";
        String complexValid = "<body id=\"useless tag\"><div attribute=someattr> <a>\tSkip to main page  <!-- Sign Up to our Newsletter --></a>  </body>";
        String broken1 = "<head><head>";
        String broken2 = "<head></body>";
        String broken3 = "Vince wants his name in the unit tests";
        TmfAbstractToolTipHandler.ToolTipString simpleHtml = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)simple);
        TmfAbstractToolTipHandler.ToolTipString normalHtml = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)normal);
        TmfAbstractToolTipHandler.ToolTipString complexHtml = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)complexValid);
        TmfAbstractToolTipHandler.ToolTipString brokenHtml1 = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)broken1);
        TmfAbstractToolTipHandler.ToolTipString brokenHtml2 = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)broken2);
        TmfAbstractToolTipHandler.ToolTipString brokenHtml3 = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)broken3);
        Assert.assertEquals((Object)"", (Object)simpleHtml.toString());
        Assert.assertEquals((Object)"Trace Compass", (Object)normalHtml.toString());
        Assert.assertEquals((Object)" \tSkip to main page    ", (Object)complexHtml.toString());
        Assert.assertEquals((Object)"", (Object)brokenHtml1.toString());
        Assert.assertEquals((Object)"", (Object)brokenHtml2.toString());
        Assert.assertEquals((Object)broken3, (Object)brokenHtml3.toString());
        Assert.assertEquals((Object)simple, (Object)simpleHtml.toHtmlString());
        Assert.assertEquals((Object)normal, (Object)normalHtml.toHtmlString());
        Assert.assertEquals((Object)complexValid, (Object)complexHtml.toHtmlString());
        Assert.assertEquals((Object)broken1, (Object)brokenHtml1.toHtmlString());
        Assert.assertEquals((Object)broken2, (Object)brokenHtml2.toHtmlString());
        Assert.assertEquals((Object)broken3, (Object)brokenHtml3.toHtmlString());
    }

    @Test
    public void testString() {
        TmfAbstractToolTipHandler.ToolTipString empty = TmfAbstractToolTipHandler.ToolTipString.fromString((String)"");
        TmfAbstractToolTipHandler.ToolTipString complicatedString = TmfAbstractToolTipHandler.ToolTipString.fromString((String)"\u00af\\_(\u30c4)_/\u00af");
        Assert.assertEquals((Object)"", (Object)empty.toString());
        Assert.assertEquals((Object)"\u00af\\_(\u30c4)_/\u00af", (Object)complicatedString.toString());
        Assert.assertEquals((Object)"", (Object)empty.toHtmlString());
        Assert.assertEquals((Object)"&macr;\\_(\u30c4)_/&macr;", (Object)complicatedString.toHtmlString());
    }

    @Test
    public void testTimestamp() {
        TmfAbstractToolTipHandler.ToolTipString ts0 = TmfAbstractToolTipHandler.ToolTipString.fromTimestamp((String)"", (long)-1L);
        TmfAbstractToolTipHandler.ToolTipString ts1 = TmfAbstractToolTipHandler.ToolTipString.fromTimestamp((String)"bob", (long)-1L);
        TmfAbstractToolTipHandler.ToolTipString ts2 = TmfAbstractToolTipHandler.ToolTipString.fromTimestamp((String)"", (long)1L);
        TmfAbstractToolTipHandler.ToolTipString ts3 = TmfAbstractToolTipHandler.ToolTipString.fromTimestamp((String)"bob", (long)1L);
        Assert.assertEquals((Object)"", (Object)ts0.toString());
        Assert.assertEquals((Object)"bob", (Object)ts1.toString());
        Assert.assertEquals((Object)"", (Object)ts2.toString());
        Assert.assertEquals((Object)"bob", (Object)ts3.toString());
        Assert.assertEquals((Object)"<a href=time://-1></a>", (Object)ts0.toHtmlString());
        Assert.assertEquals((Object)"<a href=time://-1>bob</a>", (Object)ts1.toHtmlString());
        Assert.assertEquals((Object)"<a href=time://1></a>", (Object)ts2.toHtmlString());
        Assert.assertEquals((Object)"<a href=time://1>bob</a>", (Object)ts3.toHtmlString());
    }

    @Test
    public void testEgality() {
        TmfAbstractToolTipHandler.ToolTipString fromHtml = TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)"<div>1</div>");
        TmfAbstractToolTipHandler.ToolTipString fromHtmlString = TmfAbstractToolTipHandler.ToolTipString.fromString((String)"<div>1</div>");
        TmfAbstractToolTipHandler.ToolTipString fromString = TmfAbstractToolTipHandler.ToolTipString.fromString((String)"1");
        TmfAbstractToolTipHandler.ToolTipString fromInt = TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)1);
        TmfAbstractToolTipHandler.ToolTipString fromLong = TmfAbstractToolTipHandler.ToolTipString.fromDecimal((Number)1L);
        Assert.assertNotEquals((Object)fromInt, null);
        Assert.assertNotEquals((Object)fromInt, (Object)new Object());
        Assert.assertEquals((Object)fromInt, (Object)fromInt);
        Assert.assertEquals((long)fromInt.hashCode(), (long)fromLong.hashCode());
        Assert.assertEquals((Object)fromInt, (Object)fromLong);
        Assert.assertNotEquals((Object)fromInt, (Object)fromHtml);
        Assert.assertNotEquals((Object)fromHtmlString, (Object)fromHtml);
        Assert.assertNotEquals((Object)fromHtml, (Object)TmfAbstractToolTipHandler.ToolTipString.fromHtml((String)"<a>1</a>"));
        Assert.assertEquals((long)fromString.hashCode(), (long)fromLong.hashCode());
        Assert.assertEquals((Object)fromString, (Object)fromLong);
    }
}

