/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.statistics;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfBaseColumnData;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfBaseColumnDataProvider;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TmfBaseColumnDataProviderTest {
    private static final double DELTA = 1.0E-15;
    private static final String LEVEL_COLUMN = Messages.TmfStatisticsView_LevelColumn;
    private static final String EVENTS_COUNT_COLUMN = Messages.TmfStatisticsView_NbEventsColumn;
    private TmfBaseColumnDataProvider provider;
    private static final String fTestName = "ColumnDataProviderTest";
    private final @NonNull String fTypeId1 = "Some type1";
    private final @NonNull String fTypeId2 = "Some type2";
    private final String fLabel0 = "label1";
    private final String fLabel1 = "label2";
    private final String fLabel2 = "label3";
    private final String[] fLabels = new String[]{"label1", "label2", "label3"};
    private final ITmfTimestamp fTimestamp1 = TmfTimestamp.create((long)12345L, (int)2);
    private final ITmfTimestamp fTimestamp2 = TmfTimestamp.create((long)12350L, (int)2);
    private final ITmfTimestamp fTimestamp3 = TmfTimestamp.create((long)12355L, (int)2);
    private final TmfEventType fType1 = new TmfEventType("Some type1", TmfEventField.makeRoot((String[])this.fLabels));
    private final TmfEventType fType2 = new TmfEventType("Some type1", TmfEventField.makeRoot((String[])this.fLabels));
    private final TmfEventType fType3 = new TmfEventType("Some type2", TmfEventField.makeRoot((String[])this.fLabels));
    private final ITmfEvent fEvent1;
    private final ITmfEvent fEvent2;
    private final ITmfEvent fEvent3;
    private final TmfEventField fContent1 = new TmfEventField(":root:", (Object)"Some content", null);
    private final TmfEventField fContent2;
    private final TmfEventField fContent3;
    private final TmfStatisticsTree fStatsData;

    public TmfBaseColumnDataProviderTest() {
        this.fEvent1 = new TmfEvent(null, -1L, this.fTimestamp1, (ITmfEventType)this.fType1, (ITmfEventField)this.fContent1);
        this.fContent2 = new TmfEventField(":root:", (Object)"Some other content", null);
        this.fEvent2 = new TmfEvent(null, -1L, this.fTimestamp2, (ITmfEventType)this.fType2, (ITmfEventField)this.fContent2);
        this.fContent3 = new TmfEventField(":root:", (Object)"Some other different content", null);
        this.fEvent3 = new TmfEvent(null, -1L, this.fTimestamp3, (ITmfEventType)this.fType3, (ITmfEventField)this.fContent3);
        this.fStatsData = new TmfStatisticsTree();
        this.fStatsData.getOrCreateNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes});
        this.fStatsData.setTotal(fTestName, true, 3L);
        this.fStatsData.setTypeCount(fTestName, this.fEvent1.getName(), true, 1L);
        this.fStatsData.setTypeCount(fTestName, this.fEvent2.getName(), true, 1L);
        this.fStatsData.setTypeCount(fTestName, this.fEvent3.getName(), true, 1L);
        this.provider = new TmfBaseColumnDataProvider();
    }

    @Test
    public void testGetColumnData() {
        List columnsData = this.provider.getColumnData();
        Assert.assertNotNull((String)"getColumnData", (Object)columnsData);
        Assert.assertEquals((String)"getColumnData", (long)4L, (long)columnsData.size());
        TmfStatisticsTreeNode parentNode = this.fStatsData.getNode(new String[]{fTestName});
        TmfStatisticsTreeNode treeNode1 = this.fStatsData.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, this.fEvent1.getName()});
        TmfStatisticsTreeNode treeNode2 = this.fStatsData.getNode(new String[]{fTestName, Messages.TmfStatisticsData_EventTypes, this.fEvent3.getName()});
        ViewerComparator vComp = null;
        for (TmfBaseColumnData columnData : columnsData) {
            Assert.assertNotNull((String)"getColumnData", (Object)columnData);
            Assert.assertNotNull((String)"getColumnData", (Object)columnData.getHeader());
            Assert.assertNotNull((String)"getColumnData", (Object)columnData.getTooltip());
            ColumnLabelProvider labelProvider = columnData.getLabelProvider();
            if (columnData.getHeader().compareTo(LEVEL_COLUMN) == 0) {
                Assert.assertEquals((String)"getColumnData", (long)0L, (long)labelProvider.getText((Object)treeNode1).compareTo(treeNode1.getName()));
            } else if (columnData.getHeader().compareTo(EVENTS_COUNT_COLUMN) == 0) {
                Assert.assertEquals((String)"getColumnData", (Object)"1", (Object)labelProvider.getText((Object)treeNode1));
            }
            vComp = columnData.getComparator();
            if (columnData.getHeader().compareTo(LEVEL_COLUMN) == 0) {
                Assert.assertTrue((String)"getColumnData", (vComp.compare(null, (Object)treeNode1, (Object)treeNode2) < 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"getColumnData", (vComp.compare(null, (Object)treeNode2, (Object)treeNode1) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"getColumnData", (vComp.compare(null, (Object)treeNode1, (Object)treeNode1) == 0 ? 1 : 0) != 0);
            } else if (columnData.getHeader().compareTo(EVENTS_COUNT_COLUMN) == 0) {
                Assert.assertTrue((String)"getColumnData", (vComp.compare(null, (Object)treeNode1, (Object)treeNode2) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"getColumnData", (vComp.compare(null, (Object)treeNode2, (Object)treeNode1) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"getColumnData", (vComp.compare(null, (Object)treeNode1, (Object)treeNode1) == 0 ? 1 : 0) != 0);
            }
            TmfBaseColumnData.ITmfColumnPercentageProvider percentProvider = columnData.getPercentageProvider();
            if (columnData.getHeader().compareTo(LEVEL_COLUMN) == 0) {
                Assert.assertNull((String)"getColumnData", (Object)percentProvider);
                continue;
            }
            if (columnData.getHeader().compareTo(EVENTS_COUNT_COLUMN) != 0) continue;
            double percentage = (double)treeNode1.getValues().getTotal() / (double)parentNode.getValues().getTotal();
            Assert.assertEquals((String)"getColumnData", (double)percentage, (double)percentProvider.getPercentage(treeNode1), (double)1.0E-15);
        }
    }
}

