/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.ChangeEventStateHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;

public class EnableEventHandler
extends ChangeEventStateHandler {
    @Override
    protected TraceEnablement getNewState() {
        return TraceEnablement.ENABLED;
    }

    @Override
    protected void changeState(TraceChannelComponent channel, List<String> eventNames, TraceLogLevel logLevel, LogLevelType logLevelType, TraceEventType eventType, String probe, IProgressMonitor monitor) throws ExecutionException {
        if (logLevelType.equals((Object)LogLevelType.LOGLEVEL_NONE) || logLevelType.equals((Object)LogLevelType.LOGLEVEL_ALL)) {
            switch (eventType) {
                case FUNCTION: {
                    channel.enableProbe(String.join((CharSequence)",", eventNames), true, probe, monitor);
                    break;
                }
                case PROBE: {
                    channel.enableProbe(String.join((CharSequence)",", eventNames), false, probe, monitor);
                    break;
                }
                case SYSCALL: {
                    channel.enableSyscalls(eventNames, monitor);
                    break;
                }
                case TRACEPOINT: {
                    channel.enableEvents(eventNames, monitor);
                    break;
                }
                case UNKNOWN: {
                    break;
                }
            }
        } else {
            channel.enableLogLevel(eventNames, logLevelType, (ITraceLogLevel)logLevel, null, channel.getDomain(), monitor);
        }
    }
}

