/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.segmentstore.core.segmentHistoryTree;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.IHTNode;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping.OverlappingNode;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;

public class SegmentTreeNode<E extends ISegment>
extends OverlappingNode<E> {
    private long fMaxStart = 0L;
    private long fMinEnd = Long.MAX_VALUE;
    private long fShortest = Long.MAX_VALUE;
    private long fLongest = 0L;

    public SegmentTreeNode(IHTNode.NodeType type, int blockSize, int maxChildren, int seqNumber, int parentSeqNumber, long start) {
        super(type, blockSize, maxChildren, seqNumber, parentSeqNumber, start);
        this.fMaxStart = start;
    }

    protected @Nullable OverlappingSegmentCoreData<E> createNodeExtraData(IHTNode.NodeType type) {
        if (type == IHTNode.NodeType.CORE) {
            return new OverlappingSegmentCoreData(this);
        }
        return null;
    }

    public int getNumIntervals() {
        return this.getIntervals().size();
    }

    public void add(E newInterval) {
        super.add(newInterval);
        this.updateBoundaries(newInterval);
    }

    public long getMaxStart() {
        return this.fMaxStart;
    }

    public long getMinEnd() {
        return this.fMinEnd != Long.MAX_VALUE ? this.fMinEnd : this.getNodeStart();
    }

    public long getShortest() {
        return this.fShortest;
    }

    public long getLongest() {
        return this.fLongest;
    }

    protected void readSpecificHeader(@NonNull ByteBuffer buffer) {
        super.readSpecificHeader(buffer);
        this.fMaxStart = buffer.getLong();
        this.fMinEnd = buffer.getLong();
        this.fShortest = buffer.getLong();
        this.fLongest = buffer.getLong();
    }

    protected void writeSpecificHeader(@NonNull ByteBuffer buffer) {
        super.writeSpecificHeader(buffer);
        buffer.putLong(this.fMaxStart);
        buffer.putLong(this.fMinEnd);
        buffer.putLong(this.fShortest);
        buffer.putLong(this.fLongest);
    }

    protected int getSpecificHeaderSize() {
        return super.getSpecificHeaderSize() + 32;
    }

    public Set<Tuple<ISegment>> selectNextChildren(TimeRangeCondition range, Comparator<E> order) {
        OverlappingNode.OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            HashSet<Tuple<ISegment>> set = new HashSet<Tuple<ISegment>>();
            for (Integer index : extraData.selectNextIndices(range)) {
                set.add(new Tuple<ISegment>(extraData.getIndex(index, order), extraData.getChild(index.intValue())));
            }
            return set;
        }
        return Collections.emptySet();
    }

    protected @Nullable OverlappingSegmentCoreData<E> getCoreNodeData() {
        return (OverlappingSegmentCoreData)super.getCoreNodeData();
    }

    protected long getMaxStart(int index) {
        OverlappingNode.OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getMaxStart(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    protected long getMinEnd(int index) {
        OverlappingNode.OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getMinEnd(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    protected long getShortest(int index) {
        OverlappingNode.OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getShortest(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    protected long getLongest(int index) {
        OverlappingNode.OverlappingExtraData extraData = this.getCoreNodeData();
        if (extraData != null) {
            return extraData.getLongest(index);
        }
        throw new UnsupportedOperationException("A leaf node does not have children");
    }

    @Nullable Tuple<E> key(Comparator<@NonNull E> order) {
        if (this.isEmpty()) {
            return null;
        }
        return new Tuple<ISegment>((ISegment)Collections.min(this.getIntervals(), order), this.getSequenceNumber());
    }

    private void updateBoundaries(E segment) {
        this.fMaxStart = Math.max(this.fMaxStart, segment.getStart());
        this.fMinEnd = Math.min(this.fMinEnd, segment.getEnd());
        this.fShortest = Math.min(this.fShortest, segment.getLength());
        this.fLongest = Math.max(this.fLongest, segment.getLength());
    }

    protected static class OverlappingSegmentCoreData<E extends ISegment>
    extends OverlappingNode.OverlappingExtraData {
        private final long[] fChildMaxStart;
        private final long[] fChildMinEnd;
        private final long[] fMinLength;
        private final long[] fMaxLength;

        public OverlappingSegmentCoreData(SegmentTreeNode<?> node) {
            super(node);
            int size = ((SegmentTreeNode)this.getNode()).getMaxChildren();
            this.fChildMaxStart = new long[size];
            this.fChildMinEnd = new long[size];
            this.fMinLength = new long[size];
            this.fMaxLength = new long[size];
            int i = 0;
            while (i < size) {
                this.fChildMaxStart[i] = 0L;
                this.fChildMinEnd[i] = Long.MAX_VALUE;
                this.fMinLength[i] = Long.MAX_VALUE;
                this.fMaxLength[i] = Long.MIN_VALUE;
                ++i;
            }
        }

        protected SegmentTreeNode<?> getNode() {
            return (SegmentTreeNode)super.getNode();
        }

        public void readSpecificHeader(@NonNull ByteBuffer buffer) {
            super.readSpecificHeader(buffer);
            int size = ((SegmentTreeNode)this.getNode()).getMaxChildren();
            int i = 0;
            while (i < size) {
                this.fChildMaxStart[i] = buffer.getLong();
                this.fChildMinEnd[i] = buffer.getLong();
                this.fMinLength[i] = buffer.getLong();
                this.fMaxLength[i] = buffer.getLong();
                ++i;
            }
        }

        protected void writeSpecificHeader(@NonNull ByteBuffer buffer) {
            ((SegmentTreeNode)this.getNode()).takeReadLock();
            try {
                super.writeSpecificHeader(buffer);
                int size = ((SegmentTreeNode)this.getNode()).getMaxChildren();
                int i = 0;
                while (i < size) {
                    buffer.putLong(this.fChildMaxStart[i]);
                    buffer.putLong(this.fChildMinEnd[i]);
                    buffer.putLong(this.fMinLength[i]);
                    buffer.putLong(this.fMaxLength[i]);
                    ++i;
                }
            }
            finally {
                ((SegmentTreeNode)this.getNode()).releaseReadLock();
            }
        }

        protected int getSpecificHeaderSize() {
            int maxChildren = ((SegmentTreeNode)this.getNode()).getMaxChildren();
            int specificSize = super.getSpecificHeaderSize();
            return specificSize += 32 * maxChildren;
        }

        public void linkNewChild(IHTNode<?> childNode) {
            if (!(childNode instanceof SegmentTreeNode)) {
                throw new IllegalArgumentException("Adding a node that is not an segment tree node to an segment tree!");
            }
            ((SegmentTreeNode)this.getNode()).takeWriteLock();
            try {
                super.linkNewChild(childNode);
                int childIndex = this.getNbChildren() - 1;
                if (!(childNode instanceof SegmentTreeNode)) {
                    return;
                }
                SegmentTreeNode segmentNode = (SegmentTreeNode)childNode;
                this.updateChild(segmentNode, childIndex);
                segmentNode.addListener((node, endtime) -> this.updateChild((SegmentTreeNode)node, childIndex));
            }
            finally {
                ((SegmentTreeNode)this.getNode()).releaseWriteLock();
            }
        }

        private void updateChild(SegmentTreeNode<E> child, int childIndex) {
            this.fChildMaxStart[childIndex] = child.getMaxStart();
            this.fChildMinEnd[childIndex] = child.getMinEnd();
            this.fMinLength[childIndex] = child.getShortest();
            this.fMaxLength[childIndex] = child.getLongest();
            int i = 0;
            while (i < child.getNbChildren()) {
                this.fChildMaxStart[childIndex] = Math.max(this.fChildMaxStart[childIndex], child.getMaxStart(i));
                this.fChildMinEnd[childIndex] = Math.min(this.fChildMinEnd[childIndex], child.getMinEnd(i));
                this.fMinLength[childIndex] = Math.min(this.fMinLength[childIndex], child.getShortest(i));
                this.fMaxLength[childIndex] = Math.max(this.fMaxLength[childIndex], child.getLongest(i));
                ++i;
            }
        }

        protected Collection<Integer> selectNextIndices(TimeRangeCondition rc) {
            return super.selectNextIndices(rc);
        }

        public long getMaxStart(int index) {
            ((SegmentTreeNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildMaxStart[index];
                return l;
            }
            finally {
                ((SegmentTreeNode)this.getNode()).releaseReadLock();
            }
        }

        public long getMinEnd(int index) {
            ((SegmentTreeNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildMinEnd[index];
                return l;
            }
            finally {
                ((SegmentTreeNode)this.getNode()).releaseReadLock();
            }
        }

        public long getShortest(int index) {
            ((SegmentTreeNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fMinLength[index];
                return l;
            }
            finally {
                ((SegmentTreeNode)this.getNode()).releaseReadLock();
            }
        }

        public long getLongest(int index) {
            ((SegmentTreeNode)this.getNode()).takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fMaxLength[index];
                return l;
            }
            finally {
                ((SegmentTreeNode)this.getNode()).releaseReadLock();
            }
        }

        public ISegment getIndex(int index, Comparator<E> order) {
            if (order.equals(SegmentComparators.INTERVAL_START_COMPARATOR)) {
                return new BasicSegment(this.getChildStart(index), this.getChildStart(index));
            }
            if (order.equals(SegmentComparators.INTERVAL_START_COMPARATOR.reversed())) {
                return new BasicSegment(this.fChildMaxStart[index], this.fChildMaxStart[index]);
            }
            if (order.equals(SegmentComparators.INTERVAL_END_COMPARATOR)) {
                return new BasicSegment(this.fChildMinEnd[index], this.fChildMinEnd[index]);
            }
            if (order.equals(SegmentComparators.INTERVAL_END_COMPARATOR.reversed())) {
                return new BasicSegment(this.getChildEnd(index), this.getChildEnd(index));
            }
            if (order.equals(SegmentComparators.INTERVAL_LENGTH_COMPARATOR)) {
                return new BasicSegment(0L, this.fMinLength[index]);
            }
            if (order.equals(SegmentComparators.INTERVAL_LENGTH_COMPARATOR.reversed())) {
                return new BasicSegment(0L, this.fMaxLength[index]);
            }
            return new BasicSegment(this.getChild(index), this.getChild(index));
        }
    }

    static class Tuple<E> {
        private final E fSegment;
        private final int fNodeSequenceNumber;

        public Tuple(E segment, int nodeSequenceNumber) {
            this.fSegment = segment;
            this.fNodeSequenceNumber = nodeSequenceNumber;
        }

        public E getSegment() {
            return this.fSegment;
        }

        public int getSequenceNumber() {
            return this.fNodeSequenceNumber;
        }
    }
}

