/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class IntroduceParameterRefactoring
extends ScriptableRefactoring
implements IDelegateUpdating {
    private static final String ATTRIBUTE_ARGUMENT = "argument";
    private static final String[] KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is"};
    private IJavaScriptUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private IFunction fMethod;
    private ChangeSignatureRefactoring fChangeSignatureRefactoring;
    private ParameterInfo fParameter;
    private String fParameterName;
    private RefactoringArguments fArguments;
    private Expression fSelectedExpression;
    private String[] fExcludedParameterNames;

    public IntroduceParameterRefactoring(IJavaScriptUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSourceCU = unit;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
    }

    @Override
    public boolean canEnableDelegateUpdating() {
        return true;
    }

    @Override
    public boolean getDelegateUpdating() {
        return this.fChangeSignatureRefactoring != null ? this.fChangeSignatureRefactoring.getDelegateUpdating() : false;
    }

    @Override
    public void setDelegateUpdating(boolean updating) {
        if (this.fChangeSignatureRefactoring != null) {
            this.fChangeSignatureRefactoring.setDelegateUpdating(updating);
        }
    }

    @Override
    public void setDeprecateDelegates(boolean deprecate) {
        if (this.fChangeSignatureRefactoring != null) {
            this.fChangeSignatureRefactoring.setDeprecateDelegates(deprecate);
        }
    }

    @Override
    public boolean getDeprecateDelegates() {
        return this.fChangeSignatureRefactoring != null ? this.fChangeSignatureRefactoring.getDeprecateDelegates() : false;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterRefactoring_name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            CompilationUnitRewrite cuRewrite;
            pm.beginTask("", 7);
            if (!this.fSourceCU.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_syntax_error);
                return refactoringStatus;
            }
            IJavaScriptElement enclosingElement = SelectionConverter.resolveEnclosingElement((IJavaScriptElement)this.fSourceCU, (ITextSelection)new TextSelection(this.fSelectionStart, this.fSelectionLength));
            if (!(enclosingElement instanceof IFunction)) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                return refactoringStatus;
            }
            this.fMethod = (IFunction)enclosingElement;
            pm.worked(1);
            RefactoringStatus result = new RefactoringStatus();
            if (this.fArguments != null) {
                this.fChangeSignatureRefactoring = new ChangeSignatureRefactoring(null);
                result = this.fChangeSignatureRefactoring.initialize(this.fArguments);
                if (result.hasFatalError()) {
                    pm.worked(2);
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
                this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                result.merge(this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 2)));
                if (result.hasFatalError()) {
                    RefactoringStatus refactoringStatus = result;
                    return refactoringStatus;
                }
            } else {
                ChangeSignatureRefactoring changeSignatureRefactoring = this.fChangeSignatureRefactoring = RefactoringAvailabilityTester.isChangeSignatureAvailable(this.fMethod) ? new ChangeSignatureRefactoring(this.fMethod) : null;
                if (this.fChangeSignatureRefactoring == null) {
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
                    return refactoringStatus;
                }
                this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
                result.merge(this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                if (result.hasFatalError()) {
                    RefactoringStatusEntry entry = result.getEntryMatchingSeverity(4);
                    if (entry.getCode() != 1 && entry.getCode() != 2) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                    IFunction method = (IFunction)entry.getData();
                    ChangeSignatureRefactoring changeSignatureRefactoring2 = this.fChangeSignatureRefactoring = RefactoringAvailabilityTester.isChangeSignatureAvailable(method) ? new ChangeSignatureRefactoring(method) : null;
                    if (this.fChangeSignatureRefactoring == null) {
                        String msg = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_cannot_introduce, entry.getMessage());
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)msg);
                        return refactoringStatus;
                    }
                    result = this.fChangeSignatureRefactoring.checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (result.hasFatalError()) {
                        RefactoringStatus refactoringStatus = result;
                        return refactoringStatus;
                    }
                } else {
                    pm.worked(1);
                }
            }
            if (!(cuRewrite = this.fChangeSignatureRefactoring.getBaseCuRewrite()).getCu().equals(this.fSourceCU)) {
                cuRewrite = new CompilationUnitRewrite(this.fSourceCU);
            }
            this.initializeSelectedExpression(cuRewrite);
            pm.worked(1);
            result.merge(this.checkSelection(cuRewrite, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.initializeExcludedParameterNames(cuRewrite);
            this.addParameterInfo(cuRewrite);
            this.fChangeSignatureRefactoring.setBodyUpdater(new BodyUpdater(){

                @Override
                public void updateBody(FunctionDeclaration methodDeclaration, CompilationUnitRewrite rewrite, RefactoringStatus updaterResult) {
                    IntroduceParameterRefactoring.this.replaceSelectedExpression(rewrite);
                }
            });
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
            if (this.fChangeSignatureRefactoring != null) {
                this.fChangeSignatureRefactoring.setValidationContext(null);
            }
        }
    }

    private void addParameterInfo(CompilationUnitRewrite cuRewrite) throws JavaScriptModelException {
        ITypeBinding typeBinding = Bindings.normalizeForDeclarationUse(this.fSelectedExpression.resolveTypeBinding(), this.fSelectedExpression.getAST());
        String typeName = cuRewrite.getImportRewrite().addImport(typeBinding);
        String name = this.fParameterName != null ? this.fParameterName : this.guessedParameterName();
        String defaultValue = this.fSourceCU.getBuffer().getText(this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        this.fParameter = ParameterInfo.createInfoForAddedParameter(typeBinding, typeName, name, defaultValue);
        if (this.fArguments == null) {
            List parameterInfos = this.fChangeSignatureRefactoring.getParameterInfos();
            int parametersCount = parameterInfos.size();
            if (parametersCount > 0 && ((ParameterInfo)parameterInfos.get(parametersCount - 1)).isOldVarargs()) {
                parameterInfos.add(parametersCount - 1, this.fParameter);
            } else {
                parameterInfos.add(this.fParameter);
            }
        }
    }

    private void replaceSelectedExpression(CompilationUnitRewrite cuRewrite) {
        if (!this.fSourceCU.equals(cuRewrite.getCu())) {
            return;
        }
        Expression expression = (Expression)NodeFinder.perform((ASTNode)cuRewrite.getRoot(), this.fSelectedExpression.getStartPosition(), this.fSelectedExpression.getLength());
        SimpleName newExpression = cuRewrite.getRoot().getAST().newSimpleName(this.fParameter.getNewName());
        String description = RefactoringCoreMessages.IntroduceParameterRefactoring_replace;
        cuRewrite.getASTRewrite().replace((ASTNode)expression, (ASTNode)newExpression, cuRewrite.createGroupDescription(description));
    }

    private void initializeSelectedExpression(CompilationUnitRewrite cuRewrite) throws JavaScriptModelException {
        IASTFragment fragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)cuRewrite.getRoot(), cuRewrite.getCu());
        if (!(fragment instanceof IExpressionFragment)) {
            return;
        }
        Expression expression = ((IExpressionFragment)fragment).getAssociatedExpression();
        if (fragment.getStartPosition() != expression.getStartPosition() || fragment.getLength() != expression.getLength()) {
            return;
        }
        if (Checks.isInsideJavadoc((ASTNode)expression)) {
            return;
        }
        this.fSelectedExpression = expression;
    }

    private RefactoringStatus checkSelection(CompilationUnitRewrite cuRewrite, IProgressMonitor pm) {
        if (this.fSelectedExpression == null) {
            String message = RefactoringCoreMessages.IntroduceParameterRefactoring_select;
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, cuRewrite.getRoot(), message);
        }
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, FunctionDeclaration.class);
        if (methodDeclaration == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_expression_in_method);
        }
        if (methodDeclaration.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_binding);
        }
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkExpression());
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(this.checkExpressionBinding());
        if (result.hasFatalError()) {
            return result;
        }
        return result;
    }

    private RefactoringStatus checkExpression() {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof Name && selectedExpression.getParent() instanceof ClassInstanceCreation) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_name_in_new);
        }
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_null_literals);
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_array_initializer);
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_assignment);
            }
            return null;
        }
        if (selectedExpression instanceof SimpleName) {
            if (((SimpleName)selectedExpression).isDeclaration()) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_names_in_declarations);
            }
            if (selectedExpression.getParent() instanceof QualifiedName && selectedExpression.getLocationInParent() == QualifiedName.NAME_PROPERTY || selectedExpression.getParent() instanceof FieldAccess && selectedExpression.getLocationInParent() == FieldAccess.NAME_PROPERTY) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractTempRefactoring_select_expression);
            }
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() {
        switch (Checks.checkExpressionIsRValue(this.fSelectedExpression)) {
            case 1: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_select, null, (String)Corext.getPluginId(), (int)64, null);
            }
            case 2: {
                return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.IntroduceParameterRefactoring_no_void, null, (String)Corext.getPluginId(), (int)65, null);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public List getParameterInfos() {
        return this.fChangeSignatureRefactoring.getParameterInfos();
    }

    public ParameterInfo getAddedParameterInfo() {
        return this.fParameter;
    }

    public String getMethodSignaturePreview() throws JavaScriptModelException {
        return this.fChangeSignatureRefactoring.getNewMethodSignature();
    }

    public void setParameterName(String name) {
        Assert.isNotNull((Object)name);
        this.fParameter.setNewName(name);
    }

    public String guessedParameterName() {
        String[] proposals = this.guessParameterNames();
        if (proposals.length == 0) {
            return "";
        }
        return proposals[0];
    }

    public String[] guessParameterNames() {
        LinkedHashSet proposals = new LinkedHashSet();
        if (this.fSelectedExpression instanceof FunctionInvocation) {
            proposals.addAll(this.guessTempNamesFromMethodInvocation((FunctionInvocation)this.fSelectedExpression, this.fExcludedParameterNames));
        }
        proposals.addAll(this.guessTempNamesFromExpression(this.fSelectedExpression, this.fExcludedParameterNames));
        return proposals.toArray(new String[proposals.size()]);
    }

    private List guessTempNamesFromMethodInvocation(FunctionInvocation selectedMethodInvocation, String[] excludedVariableNames) {
        String methodName;
        SimpleName name = selectedMethodInvocation.getName();
        if (name != null) {
            methodName = name.getIdentifier();
            int i = 0;
            while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
                String prefix = KNOWN_METHOD_NAME_PREFIXES[i];
                if (methodName.startsWith(prefix)) {
                    if (methodName.length() == prefix.length()) {
                        return Collections.EMPTY_LIST;
                    }
                    char firstAfterPrefix = methodName.charAt(prefix.length());
                    if (Character.isUpperCase(firstAfterPrefix)) {
                        String proposal;
                        methodName = proposal = String.valueOf(Character.toLowerCase(firstAfterPrefix)) + methodName.substring(prefix.length() + 1);
                        break;
                    }
                }
                ++i;
            }
        } else {
            methodName = "indirectFunctionCall";
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaScriptProject(), methodName, 0, excludedVariableNames);
        return Arrays.asList(proposals);
    }

    private List guessTempNamesFromExpression(Expression selectedExpression, String[] excluded) {
        ITypeBinding expressionBinding = Bindings.normalizeForDeclarationUse(selectedExpression.resolveTypeBinding(), selectedExpression.getAST());
        String typeName = IntroduceParameterRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        int typeParamStart = typeName.indexOf("<");
        if (typeParamStart != -1) {
            typeName = typeName.substring(0, typeParamStart);
        }
        String[] proposals = StubUtility.getLocalNameSuggestions(this.fSourceCU.getJavaScriptProject(), typeName, expressionBinding.getDimensions(), excluded);
        return Arrays.asList(proposals);
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames(CompilationUnitRewrite cuRewrite) {
        IBinding[] bindings = new ScopeAnalyzer(cuRewrite.getRoot()).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[bindings.length];
        int i = 0;
        while (i < this.fExcludedParameterNames.length) {
            this.fExcludedParameterNames[i] = bindings[i].getName();
            ++i;
        }
    }

    public RefactoringStatus validateInput() {
        return this.fChangeSignatureRefactoring.checkSignature();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            result = this.fChangeSignatureRefactoring.checkFinalConditions(pm);
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        RefactoringDescriptor refactoringDescriptor;
        ChangeDescriptor descriptor;
        Object result;
        this.fChangeSignatureRefactoring.setValidationContext(this.getValidationContext());
        try {
            result = this.fChangeSignatureRefactoring.createChange(pm);
        }
        finally {
            this.fChangeSignatureRefactoring.setValidationContext(null);
        }
        if (result != null && (descriptor = result.getDescriptor()) instanceof RefactoringChangeDescriptor && (refactoringDescriptor = ((RefactoringChangeDescriptor)descriptor).getRefactoringDescriptor()) instanceof JDTRefactoringDescriptor) {
            JDTRefactoringDescriptor extended = (JDTRefactoringDescriptor)refactoringDescriptor;
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put(ATTRIBUTE_ARGUMENT, this.fParameter.getNewName());
            arguments.put("selection", String.valueOf(Integer.valueOf(this.fSelectionStart).toString()) + " " + Integer.valueOf(this.fSelectionLength).toString());
            arguments.putAll(extended.getArguments());
            String signature = this.fChangeSignatureRefactoring.getMethodName();
            try {
                signature = this.fChangeSignatureRefactoring.getOldMethodSignature();
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description_short, this.fChangeSignatureRefactoring.getMethod().getElementName());
            String header = Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_descriptor_description, new String[]{this.fParameter.getNewName(), signature, ASTNodes.asString((ASTNode)this.fSelectedExpression)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(extended.getProject(), this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_original_pattern, JavaScriptElementLabels.getTextLabel(this.fChangeSignatureRefactoring.getMethod(), 2235681801344L)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_expression_pattern, ASTNodes.asString((ASTNode)this.fSelectedExpression)));
            comment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceParameterRefactoring_parameter_pattern, this.getAddedParameterInfo().getNewName()));
            result = new RefactoringDescriptorChange((RefactoringDescriptor)new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.introduce.parameter", extended.getProject(), description, comment.asString(), arguments, extended.getFlags()), RefactoringCoreMessages.IntroduceParameterRefactoring_name, new Change[]{result});
        }
        return result;
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        this.fArguments = arguments;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            int length;
            int offset;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                offset = -1;
                length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset < 0 || length < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = offset;
            this.fSelectionLength = length;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 5) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.introduce.parameter");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fSourceCU = ((IFunction)element).getJavaScriptUnit();
            name = extended.getAttribute(ATTRIBUTE_ARGUMENT);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ARGUMENT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fParameterName = name;
        return new RefactoringStatus();
    }

    @Override
    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateCreator_keep_original_changed_plural;
        }
        return RefactoringCoreMessages.DelegateCreator_keep_original_changed_singular;
    }
}

