/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.custom.StructuredTextOffsets;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;

public class StructuredTextRegex
extends StructuredTextTypeHandler {
    static final String[] startStrings = new String[]{"", "(?#", "(?<", "(?'", "(?(<", "(?('", "(?(", "(?&", "(?P<", "\\k<", "\\k'", "\\k{", "(?P=", "\\g{", "\\g<", "\\g'", "(?(R&", "\\Q"};
    static final char[] endChars = new char[]{'.', ')', '>', '\'', ')', ')', ')', ')', '>', '>', '\'', '}', ')', '}', '>', '\'', ')'};
    static final int numberOfStrings;
    static final int maxSpecial;
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;
    static final byte AN = 6;
    static final byte EN = 3;
    private static final Integer STATE_COMMENT;
    private static final Integer STATE_QUOTED_SEQUENCE;

    static {
        maxSpecial = numberOfStrings = startStrings.length;
        STATE_COMMENT = 1;
        STATE_QUOTED_SEQUENCE = 17;
    }

    @Override
    public int getSpecialsCount(IStructuredTextExpert expert) {
        return maxSpecial;
    }

    @Override
    public int indexOfSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int fromIndex) {
        if (caseNumber < numberOfStrings) {
            return text.indexOf(startStrings[caseNumber], fromIndex);
        }
        if (fromIndex <= 0) {
            fromIndex = 1;
        }
        while (fromIndex < text.length()) {
            byte charType = charTypes.getBidiTypeAt(fromIndex);
            if (charType == 1 || charType == 2) {
                return fromIndex;
            }
            if ((charType == 3 || charType == 6) && charTypes.getBidiTypeAt(fromIndex - 1) != charType) {
                int i = fromIndex - 1;
                while (i >= 0) {
                    charType = charTypes.getBidiTypeAt(i);
                    if (charType != 0 && (charType == 1 || charType == 2 || charType == 6)) {
                        return fromIndex;
                    }
                    --i;
                }
            }
            ++fromIndex;
        }
        return -1;
    }

    @Override
    public int processSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int separLocation) {
        if (separLocation < 0) {
            caseNumber = (Integer)expert.getState();
            expert.clearState();
        }
        switch (caseNumber) {
            case 1: {
                int location;
                if (separLocation < 0) {
                    location = 0;
                } else {
                    StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
                    location = separLocation + 3;
                }
                location = text.indexOf(41, location);
                if (location < 0) {
                    expert.setState(STATE_COMMENT);
                    return text.length();
                }
                return location + 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                int location = separLocation + startStrings[caseNumber].length();
                location = text.indexOf(endChars[caseNumber], location);
                if (location < 0) {
                    return text.length();
                }
                return location + 1;
            }
            case 17: {
                int location;
                if (separLocation < 0) {
                    location = 0;
                } else {
                    StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
                    location = separLocation + 2;
                }
                location = text.indexOf("\\E", location);
                if (location < 0) {
                    expert.setState(STATE_QUOTED_SEQUENCE);
                    return text.length();
                }
                charTypes.setBidiTypeAt(location + 1, (byte)0);
                return location + 2;
            }
            case 18: {
                StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
                return separLocation + 1;
            }
        }
        return text.length();
    }

    @Override
    public int getDirection(IStructuredTextExpert expert, String text) {
        return this.getDirection(expert, text, new StructuredTextCharTypes(expert, text));
    }

    @Override
    public int getDirection(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes) {
        StructuredTextEnvironment environment = expert.getEnvironment();
        String language = environment.getLanguage();
        if (!language.equals("ar")) {
            return 0;
        }
        int i = 0;
        while (i < text.length()) {
            byte charType = charTypes.getBidiTypeAt(i);
            if (charType == 2 || charType == 1) {
                return 1;
            }
            if (charType == 0) {
                return 0;
            }
            ++i;
        }
        if (environment.getMirrored()) {
            return 1;
        }
        return 0;
    }
}

