/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.ui.project.handlers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public abstract class LaunchElementTypeContributionItem
extends CompoundContributionItem {
    private static final String TYPE_PARAMETER = "org.eclipse.tracecompass.incubator.scripting.ui.commandparameter.launch_as_ease_script.type";
    private static final String MODE_PARAMETER = "org.eclipse.tracecompass.incubator.scripting.ui.commandparameter.launch_as_ease_script.mode";
    private static final String LAUNCH_AS_EASE_SCRIPT_COMMAND_ID = "org.eclipse.tracecompass.incubator.scripting.ui.command.launch_as_ease_script";
    private static final String LAUCH_DIALOG_STRING = "Configuration...";
    private static final String RUN_STRING = "Run";
    private static final String DEBUG_STRING = "Debug";
    private static final String LAUNCH_COMMAND_CONTRIBUTION_ITEM_ID = "org.eclipse.tracecompass.incubator.scripting.contribution.item.id";
    private static final Comparator<IContributionItem> ITEM_COMPARATOR = new ItemComparator();
    public static final String LAUNCH_DIALOG_CONFIG_ID = "org.eclipse.tracecompass.incubator.scripting.ui.launch-dialog";

    protected IContributionItem[] getContributionItems() {
        HashSet<Pair<String, String>> availableShortcuts = new HashSet<Pair<String, String>>(this.getParam());
        Pair<String, String> launchConfiguration = this.getLaunchConfigurationParam();
        if (launchConfiguration != null) {
            availableShortcuts.add(launchConfiguration);
        }
        LinkedList<CommandContributionItem> list = new LinkedList<CommandContributionItem>();
        for (Pair pair : availableShortcuts) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(TYPE_PARAMETER, (String)pair.getFirst());
            params.put(MODE_PARAMETER, this.getLaunchMode());
            CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), LAUNCH_COMMAND_CONTRIBUTION_ITEM_ID, this.getContributionItemCommandId(), 8);
            param.parameters = params;
            param.label = (String)pair.getSecond();
            param.visibleEnabled = true;
            list.add(new CommandContributionItem(param));
        }
        Collections.sort(list, ITEM_COMPARATOR);
        return list.toArray(new IContributionItem[list.size()]);
    }

    protected String getContributionItemCommandId() {
        return LAUNCH_AS_EASE_SCRIPT_COMMAND_ID;
    }

    protected abstract String getLaunchMode();

    protected abstract Set<Pair<String, String>> getParam();

    private @Nullable Pair<String, String> getLaunchConfigurationParam() {
        if (this.getLaunchMode().equals("run")) {
            return new Pair((Object)LAUNCH_DIALOG_CONFIG_ID, (Object)"Run Configuration...");
        }
        if (this.getLaunchMode().equals("debug")) {
            return new Pair((Object)LAUNCH_DIALOG_CONFIG_ID, (Object)"Debug Configuration...");
        }
        return null;
    }

    private static final class ItemComparator
    implements Comparator<IContributionItem> {
        private ItemComparator() {
        }

        @Override
        public int compare(IContributionItem o1, IContributionItem o2) {
            CommandContributionItem c1 = (CommandContributionItem)o1;
            CommandContributionItem c2 = (CommandContributionItem)o2;
            if (c1.getData().label.equals(c2.getData().label)) {
                return 0;
            }
            if (c1.getData().label.endsWith(LaunchElementTypeContributionItem.LAUCH_DIALOG_STRING)) {
                return 1;
            }
            if (c2.getData().label.endsWith(LaunchElementTypeContributionItem.LAUCH_DIALOG_STRING)) {
                return -1;
            }
            return c1.getData().label.compareTo(c2.getData().label);
        }
    }
}

