/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import java.util.Collections;
import java.util.List;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;

public class SegmentStoreStatisticsModel
extends TmfTreeDataModel {
    private final long fMin;
    private final long fMax;
    private final long fNbElements;
    private final double fMean;
    private final double fStdDev;
    private final double fTotal;
    private final long fMinStart;
    private final long fMinEnd;
    private final long fMaxStart;
    private final long fMaxEnd;

    public SegmentStoreStatisticsModel(long id, long parentId, String name, IStatistics<ISegment> statistics) {
        this(id, parentId, Collections.singletonList(name), statistics);
    }

    public SegmentStoreStatisticsModel(long id, long parentId, List<String> labels, IStatistics<ISegment> statistics) {
        super(id, parentId, labels);
        this.fMin = statistics.getMin();
        this.fMax = statistics.getMax();
        this.fNbElements = statistics.getNbElements();
        this.fMean = statistics.getMean();
        this.fStdDev = statistics.getStdDev();
        this.fTotal = statistics.getTotal();
        ISegment max = statistics.getMaxObject();
        if (max != null) {
            this.fMaxStart = max.getStart();
            this.fMaxEnd = max.getEnd();
        } else {
            this.fMaxStart = 0L;
            this.fMaxEnd = 0L;
        }
        ISegment min = statistics.getMinObject();
        if (min != null) {
            this.fMinStart = min.getStart();
            this.fMinEnd = min.getEnd();
        } else {
            this.fMinStart = 0L;
            this.fMinEnd = 0L;
        }
    }

    public long getMin() {
        return this.fMin;
    }

    public long getMax() {
        return this.fMax;
    }

    public long getNbElements() {
        return this.fNbElements;
    }

    public double getMean() {
        return this.fMean;
    }

    public double getStdDev() {
        return this.fStdDev;
    }

    public double getTotal() {
        return this.fTotal;
    }

    public long getMinStart() {
        return this.fMinStart;
    }

    public long getMinEnd() {
        return this.fMinEnd;
    }

    public long getMaxStart() {
        return this.fMaxStart;
    }

    public long getMaxEnd() {
        return this.fMaxEnd;
    }
}

