/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.Statement;

public class ForStatement
extends Statement {
    public static final ChildListPropertyDescriptor INITIALIZERS_PROPERTY = new ChildListPropertyDescriptor(ForStatement.class, "initializers", Expression.class, true);
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(ForStatement.class, "expression", Expression.class, false, true);
    public static final ChildListPropertyDescriptor UPDATERS_PROPERTY = new ChildListPropertyDescriptor(ForStatement.class, "updaters", Expression.class, true);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(ForStatement.class, "body", Statement.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private ASTNode.NodeList initializers = new ASTNode.NodeList(INITIALIZERS_PROPERTY);
    private Expression optionalConditionExpression = null;
    private ASTNode.NodeList updaters = new ASTNode.NodeList(UPDATERS_PROPERTY);
    private Statement body = null;

    static {
        ArrayList properyList = new ArrayList(5);
        ForStatement.createPropertyList(ForStatement.class, properyList);
        ForStatement.addProperty(INITIALIZERS_PROPERTY, properyList);
        ForStatement.addProperty(EXPRESSION_PROPERTY, properyList);
        ForStatement.addProperty(UPDATERS_PROPERTY, properyList);
        ForStatement.addProperty(BODY_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS = ForStatement.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    ForStatement(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ForStatement.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Statement)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == INITIALIZERS_PROPERTY) {
            return this.initializers();
        }
        if (property == UPDATERS_PROPERTY) {
            return this.updaters();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final int getNodeType0() {
        return 24;
    }

    @Override
    ASTNode clone0(AST target) {
        ForStatement result = new ForStatement(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.copyLeadingComment(this);
        result.initializers().addAll(ASTNode.copySubtrees(target, this.initializers()));
        result.setExpression((Expression)ASTNode.copySubtree(target, this.getExpression()));
        result.updaters().addAll(ASTNode.copySubtrees(target, this.updaters()));
        result.setBody((Statement)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor, this.initializers);
            this.acceptChild(visitor, this.getExpression());
            this.acceptChildren(visitor, this.updaters);
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public List initializers() {
        return this.initializers;
    }

    public Expression getExpression() {
        return this.optionalConditionExpression;
    }

    public void setExpression(Expression expression) {
        Expression oldChild = this.optionalConditionExpression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.optionalConditionExpression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    public List updaters() {
        return this.updaters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement getBody() {
        if (this.body == null) {
            ForStatement forStatement = this;
            synchronized (forStatement) {
                if (this.body == null) {
                    this.preLazyInit();
                    this.body = new Block(this.ast);
                    this.postLazyInit(this.body, BODY_PROPERTY);
                }
            }
        }
        return this.body;
    }

    public void setBody(Statement statement) {
        if (statement == null) {
            throw new IllegalArgumentException();
        }
        Statement oldChild = this.body;
        this.preReplaceChild(oldChild, statement, BODY_PROPERTY);
        this.body = statement;
        this.postReplaceChild(oldChild, statement, BODY_PROPERTY);
    }

    @Override
    int memSize() {
        return super.memSize() + 16;
    }

    @Override
    int treeSize() {
        return this.memSize() + this.initializers.listSize() + this.updaters.listSize() + (this.optionalConditionExpression == null ? 0 : this.getExpression().treeSize()) + (this.body == null ? 0 : this.getBody().treeSize());
    }
}

