/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class MouseMoveCursorEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private Cursor defaultCursor = null;
    private ToolTip tooltip = null;

    @Override
    public int getEvent() {
        return 4;
    }

    @Override
    public int getStateMask() {
        return 0;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        Display display = baseChart.getDisplay();
        if (baseChart.getChartSettings().isEnableTooltips()) {
            String selectedSeriesId;
            if (this.defaultCursor == null) {
                this.defaultCursor = display.getSystemCursor(0);
            }
            if (this.tooltip == null) {
                this.tooltip = new ToolTip(display.getActiveShell(), 0);
            }
            if ((selectedSeriesId = baseChart.getSelectedseriesId(event)).equals("")) {
                baseChart.setCursor(this.defaultCursor);
                this.tooltip.setVisible(false);
            } else {
                ISeriesSettings seriesSettings = baseChart.getSeriesSettings(selectedSeriesId);
                baseChart.setCursor(display.getSystemCursor(21));
                this.tooltip.setMessage(seriesSettings.getDescription());
                this.tooltip.setVisible(true);
                this.tooltip.setAutoHide(false);
            }
        }
    }
}

