/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    static final int DEFAULT_WIDTH = 16;
    static final int DEFAULT_HEIGHT = 16;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private final ImageDescriptor fBase;
    private final ImageDescriptor fOverlay;
    private final int fPosition;
    private final int fOffset = 3;

    public OverlayImageDescriptor(ImageDescriptor base, ImageDescriptor overlay, int pos) {
        this.fBase = base;
        this.fOverlay = overlay;
        this.fPosition = pos;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData overlayData;
        ImageData imageData = this.fBase.getImageData();
        if (imageData != null) {
            this.drawImage(imageData, 0, 0);
        }
        if ((overlayData = this.fOverlay.getImageData()) != null) {
            Point pos = null;
            switch (this.fPosition) {
                case 0: {
                    pos = new Point(-overlayData.width / 2, -overlayData.height / 2);
                    break;
                }
                case 1: {
                    pos = new Point(imageData.width - overlayData.width / 2, 0);
                    break;
                }
                case 2: {
                    pos = new Point(0, imageData.height - overlayData.height / 2);
                    break;
                }
                case 3: {
                    pos = new Point(imageData.width - overlayData.width / 2, imageData.height - overlayData.height / 2);
                }
            }
            this.drawImage(overlayData, pos.x - 3, pos.y - 3);
        }
    }

    protected Point getSize() {
        return new Point(16, 16);
    }
}

