/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;

public class FullPrecisionFloatVectorSimilarityValuesSource
extends DoubleValuesSource {
    private final float[] queryVector;
    private final String fieldName;
    private VectorSimilarityFunction vectorSimilarityFunction;

    public FullPrecisionFloatVectorSimilarityValuesSource(float[] vector, String fieldName, VectorSimilarityFunction vectorSimilarityFunction) {
        this.queryVector = vector;
        this.fieldName = fieldName;
        this.vectorSimilarityFunction = vectorSimilarityFunction;
    }

    public FullPrecisionFloatVectorSimilarityValuesSource(float[] vector, String fieldName) {
        this(vector, fieldName, null);
    }

    public DoubleValues getSimilarityScores(LeafReaderContext ctx) throws IOException {
        return this.getValues(ctx, null);
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(this.fieldName);
        if (vectorValues == null) {
            FloatVectorValues.checkField(ctx.reader(), this.fieldName);
            return DoubleValues.EMPTY;
        }
        FieldInfo fi = ctx.reader().getFieldInfos().fieldInfo(this.fieldName);
        if (fi.getVectorDimension() != this.queryVector.length) {
            throw new IllegalArgumentException("Query vector dimension does not match field dimension: " + this.queryVector.length + " != " + fi.getVectorDimension());
        }
        if (this.vectorSimilarityFunction == null) {
            this.vectorSimilarityFunction = fi.getVectorSimilarityFunction();
        }
        final KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return FullPrecisionFloatVectorSimilarityValuesSource.this.vectorSimilarityFunction.compare(FullPrecisionFloatVectorSimilarityValuesSource.this.queryVector, vectorValues.vectorValue(iterator.index()));
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= iterator.docID() && (iterator.docID() == doc || iterator.advance(doc) == doc);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, Arrays.hashCode(this.queryVector), this.vectorSimilarityFunction});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FullPrecisionFloatVectorSimilarityValuesSource other = (FullPrecisionFloatVectorSimilarityValuesSource)obj;
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals((Object)this.vectorSimilarityFunction, (Object)other.vectorSimilarityFunction) && Arrays.equals(this.queryVector, other.queryVector);
    }

    @Override
    public String toString() {
        return "FullPrecisionFloatVectorSimilarityValuesSource(fieldName=" + this.fieldName + " vectorSimilarityFunction=" + this.vectorSimilarityFunction.name() + " queryVector=" + Arrays.toString(this.queryVector) + ")";
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

