/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public abstract class StructuredFileTaskScanner
implements IFileTaskScanner,
IExecutableExtension {
    protected List<Map<String, Object>> fNewMarkerAttributeMaps = new ArrayList<Map<String, Object>>();
    List oldMarkers = null;
    private long time0;
    private String runtimeMarkerType;

    public StructuredFileTaskScanner() {
        if (Logger.DEBUG_TASKS) {
            System.out.println(String.valueOf(this.getClass().getName()) + " instance created");
        }
    }

    protected Map<String, Object> createInitialMarkerAttributes(String text, int documentLine, int startOffset, int length, int priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(6);
        attributes.put("lineNumber", new Integer(documentLine + 1));
        attributes.put("org.eclipse.core.resources.taskmarker", this.getMarkerType());
        attributes.put("charStart", new Integer(startOffset));
        attributes.put("charEnd", new Integer(startOffset + length));
        attributes.put("message", text);
        attributes.put("userEditable", Boolean.FALSE);
        switch (priority) {
            case 2: {
                attributes.put("priority", new Integer(2));
                break;
            }
            case 0: {
                attributes.put("priority", new Integer(0));
                break;
            }
            default: {
                attributes.put("priority", new Integer(1));
            }
        }
        return attributes;
    }

    @Override
    public String getMarkerType() {
        if (this.runtimeMarkerType != null) {
            return this.runtimeMarkerType;
        }
        return "org.eclipse.core.resources.taskmarker";
    }

    private String detectCharset(IFile file) {
        if (file.getType() == 1 && file.isAccessible()) {
            try {
                return file.getCharset(true);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    protected void findTasks(IDocument document, TaskTag[] taskTags, IStructuredDocumentRegion documentRegion, ITextRegion comment) {
        block9: {
            if (!this.isCommentRegion(documentRegion, comment)) break block9;
            int startOffset = documentRegion.getStartOffset(comment);
            int endOffset = documentRegion.getTextEndOffset(comment);
            try {
                int startLine = document.getLineOfOffset(startOffset);
                int endLine = document.getLineOfOffset(endOffset);
                int lineNumber = startLine;
                while (lineNumber <= endLine) {
                    IRegion line = document.getLineInformation(lineNumber);
                    int begin = Math.max(startOffset, line.getOffset());
                    int end = Math.min(endOffset, line.getOffset() + line.getLength());
                    int length = end - begin;
                    String commentedText = this.getCommentedText(document, begin, length);
                    String lowercaseText = commentedText.toLowerCase(Locale.ENGLISH);
                    int i = 0;
                    while (i < taskTags.length) {
                        block10: {
                            String markerDescription;
                            int tagIndex;
                            block11: {
                                boolean precededByWhitespaceOrNonLetter;
                                boolean followedByWhitespaceOrColon;
                                boolean isEndOfComment;
                                tagIndex = lowercaseText.indexOf(taskTags[i].getTag().toLowerCase(Locale.ENGLISH));
                                if (tagIndex < 0) break block10;
                                boolean bl = isEndOfComment = tagIndex + taskTags[i].getTag().length() == lowercaseText.length();
                                if (isEndOfComment) break block11;
                                char nextChar = lowercaseText.charAt(tagIndex + taskTags[i].getTag().length());
                                boolean bl2 = followedByWhitespaceOrColon = Character.isWhitespace(nextChar) || nextChar == ':';
                                if (!followedByWhitespaceOrColon) break block10;
                                boolean bl3 = precededByWhitespaceOrNonLetter = tagIndex == 0 || Character.isWhitespace(lowercaseText.charAt(tagIndex - 1)) || !Character.isLetter(lowercaseText.charAt(tagIndex - 1));
                                if (!precededByWhitespaceOrNonLetter) break block10;
                            }
                            if ((markerDescription = commentedText.substring(tagIndex)).trim().length() != taskTags[i].getTag().length()) {
                                if (markerDescription.length() > 120) {
                                    markerDescription = markerDescription.substring(0, 120);
                                }
                                int markerOffset = begin + tagIndex;
                                int markerLength = end - markerOffset;
                                this.fNewMarkerAttributeMaps.add(this.createInitialMarkerAttributes(markerDescription, lineNumber, markerOffset, markerLength, taskTags[i].getPriority()));
                            }
                        }
                        ++i;
                    }
                    ++lineNumber;
                }
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }

    private void findTasks(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        try {
            RegionParser parser;
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerFor(file);
            boolean didStreamParse = false;
            IEncodedDocument defaultDocument = handler.getDocumentLoader().createNewStructuredDocument();
            if (defaultDocument instanceof IStructuredDocument && (parser = ((IStructuredDocument)defaultDocument).getParser()) instanceof StructuredDocumentRegionParser) {
                didStreamParse = true;
                String charset = this.detectCharset(file);
                StructuredDocumentRegionParser documentParser = (StructuredDocumentRegionParser)parser;
                Document textDocument = new Document();
                this.setDocumentContent((IDocument)textDocument, file.getContents(true), charset);
                monitor.beginTask("", textDocument.getLength());
                documentParser.reset(new DocumentReader((IDocument)textDocument));
                documentParser.addStructuredDocumentRegionHandler(new StructuredDocumentRegionHandler((IDocument)textDocument, taskTags, monitor){
                    private final /* synthetic */ IDocument val$textDocument;
                    private final /* synthetic */ TaskTag[] val$taskTags;
                    private final /* synthetic */ IProgressMonitor val$monitor;
                    {
                        this.val$textDocument = iDocument;
                        this.val$taskTags = taskTagArray;
                        this.val$monitor = iProgressMonitor;
                    }

                    @Override
                    public void nodeParsed(IStructuredDocumentRegion documentRegion) {
                        ITextRegionList regions = documentRegion.getRegions();
                        int j = 0;
                        while (j < regions.size()) {
                            ITextRegion comment = regions.get(j);
                            StructuredFileTaskScanner.this.findTasks(this.val$textDocument, this.val$taskTags, documentRegion, comment);
                            ++j;
                        }
                        if (documentRegion.getPrevious() != null) {
                            documentRegion.getPrevious().setPrevious(null);
                            documentRegion.getPrevious().setNext(null);
                        }
                        if (this.val$monitor.isCanceled()) {
                            this.val$textDocument.set("");
                        }
                        this.val$monitor.worked(documentRegion.getLength());
                    }

                    @Override
                    public void resetNodes() {
                    }
                });
                documentParser.getDocumentRegions();
            }
            if (!didStreamParse) {
                IEncodedDocument document = handler.getDocumentLoader().createNewStructuredDocument(file);
                monitor.beginTask("", document.getLength());
                if (document instanceof IStructuredDocument) {
                    IStructuredDocumentRegion documentRegion = ((IStructuredDocument)document).getFirstStructuredDocumentRegion();
                    while (documentRegion != null) {
                        ITextRegionList regions = documentRegion.getRegions();
                        int j = 0;
                        while (j < regions.size()) {
                            ITextRegion comment = regions.get(j);
                            this.findTasks(document, taskTags, documentRegion, comment);
                            ++j;
                        }
                        monitor.worked(documentRegion.getLength());
                        documentRegion = documentRegion.getNext();
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Exception with " + file.getFullPath().toString(), e);
        }
        catch (CharacterCodingException characterCodingException) {
            Logger.log(1, "StructuredFileTaskScanner encountered CharacterCodingException reading " + file.getFullPath());
        }
        catch (Exception e) {
            Logger.logException("Exception with " + file.getFullPath().toString(), e);
        }
        monitor.done();
    }

    protected String getCommentedText(IDocument document, int begin, int length) throws BadLocationException {
        return document.get(begin, length);
    }

    protected abstract boolean isCommentRegion(IStructuredDocumentRegion var1, ITextRegion var2);

    @Override
    public synchronized Map<String, Object>[] scan(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        this.fNewMarkerAttributeMaps.clear();
        if (monitor.isCanceled() || !this.shouldScan((IResource)file)) {
            return new Map[0];
        }
        if (Logger.DEBUG_TASKSPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (taskTags.length > 0) {
            this.findTasks(file, taskTags, monitor);
        }
        if (Logger.DEBUG_TASKSPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms for " + file.getFullPath());
        }
        return this.fNewMarkerAttributeMaps.toArray(new Map[this.fNewMarkerAttributeMaps.size()]);
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String charset) {
        block15: {
            Reader in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader(contentStream, charset), 2048);
                    StringBuffer buffer = new StringBuffer(2048);
                    char[] readBuffer = new char[2048];
                    int n = in.read(readBuffer);
                    while (n > 0) {
                        buffer.append(readBuffer, 0, n);
                        n = in.read(readBuffer);
                    }
                    document.set(buffer.toString());
                }
                catch (IOException iOException) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data != null && data instanceof String) {
            this.runtimeMarkerType = data.toString();
        }
    }

    boolean shouldScan(IResource r) {
        String s = r.getName();
        return s.length() == 0 || s.charAt(0) != '.';
    }

    @Override
    public void shutdown(IProject project) {
        if (Logger.DEBUG_TASKS) {
            System.out.println(this + " shutdown for " + project.getName());
        }
    }

    @Override
    public void startup(IProject project) {
        if (Logger.DEBUG_TASKS) {
            System.out.println(this + " startup for " + project.getName());
        }
        if (Logger.DEBUG_TASKSPERF) {
            this.time0 = System.currentTimeMillis();
        }
        if (Logger.DEBUG_TASKSPERF) {
            System.out.println(System.currentTimeMillis() - this.time0 + "ms loading prefs for " + project.getName());
        }
    }
}

