/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class AnalyzerProfile {
    public static final String ANALYSIS_DATA_DIR = AnalyzerProfile.resolveDataDir();

    private static String resolveDataDir() {
        Path[] candidateFiles;
        String dirName = "analysis-data";
        String propName = "analysis.properties";
        String analysisDataDir = System.getProperty("analysis.data.dir", "");
        if (!analysisDataDir.isEmpty()) {
            return analysisDataDir;
        }
        Path lib = Paths.get("lib", new String[0]);
        for (Path file : candidateFiles = new Path[]{Paths.get(dirName, new String[0]), lib.resolve(dirName), Paths.get(propName, new String[0]), lib.resolve(propName)}) {
            if (!Files.exists(file, new LinkOption[0])) continue;
            if (Files.isDirectory(file, new LinkOption[0])) {
                analysisDataDir = file.toAbsolutePath().toString();
                break;
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) || AnalyzerProfile.getAnalysisDataDir(file).isEmpty()) break;
            analysisDataDir = AnalyzerProfile.getAnalysisDataDir(file);
            break;
        }
        if (analysisDataDir.isEmpty()) {
            throw new RuntimeException("WARNING: Can not find lexical dictionary directory! This will cause unpredictable exceptions in your application! Please refer to the manual to download the dictionaries.");
        }
        return analysisDataDir;
    }

    private static String getAnalysisDataDir(Path propFile) {
        String string;
        block8: {
            Properties prop = new Properties();
            BufferedReader reader = Files.newBufferedReader(propFile, StandardCharsets.UTF_8);
            try {
                prop.load(reader);
                string = prop.getProperty("analysis.data.dir", "");
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return "";
                }
            }
            reader.close();
        }
        return string;
    }
}

