/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.eclipse.team.internal.ui.wizards.ExportProjectSetLocationPage;
import org.eclipse.team.internal.ui.wizards.ExportProjectSetMainPage;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.XMLMemento;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectSetExportWizard
extends Wizard
implements IExportWizard {
    ExportProjectSetMainPage mainPage;
    ExportProjectSetLocationPage locationPage;
    IStructuredSelection selection;

    public ProjectSetExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TeamUIMessages.ProjectSetExportWizard_Project_Set_1);
    }

    public void addPages() {
        this.mainPage = new ExportProjectSetMainPage("projectSetMainPage", TeamUIMessages.ProjectSetExportWizard_Export_a_Project_Set_3, TeamUIPlugin.getImageDescriptor("wizban/export_projectset_wizban.svg"));
        IProject[] projects = this.selection.toList().toArray(new IProject[0]);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.setSelectedProjects(projects);
        this.locationPage = new ExportProjectSetLocationPage("projectSetLocationPage", TeamUIMessages.ProjectSetExportWizard_Export_a_Project_Set_3, TeamUIPlugin.getImageDescriptor("wizban/export_projectset_wizban.svg"));
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean performFinish() {
        boolean[] result;
        block5: {
            result = new boolean[1];
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        boolean r;
                        Object filename = ProjectSetExportWizard.this.locationPage.getFileName();
                        IPath path = IPath.fromOSString((String)filename);
                        if (path.getFileExtension() == null) {
                            filename = (String)filename + ".psf";
                        }
                        PsfFilenameStore.getInstance().remember((String)filename);
                        File file = new File((String)filename);
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Question_4, (String)TeamUIMessages.ProjectSetExportWizard_Target_directory_does_not_exist__Would_you_like_to_create_it__5);
                            if (!r) {
                                result[0] = false;
                                return;
                            }
                            r = parentFile.mkdirs();
                            if (!r) {
                                MessageDialog.openError((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Export_Problems_6, (String)TeamUIMessages.ProjectSetExportWizard_An_error_occurred_creating_the_target_directory_7);
                                result[0] = false;
                                return;
                            }
                        }
                        if (file.exists() && file.isFile() && !(r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Question_8, (String)TeamUIMessages.ProjectSetExportWizard_Target_already_exists__Would_you_like_to_overwrite_it__9))) {
                            result[0] = false;
                            return;
                        }
                        IWorkingSet[] workingSets = null;
                        if (ProjectSetExportWizard.this.mainPage.exportWorkingSets.getSelection()) {
                            workingSets = ProjectSetExportWizard.this.mainPage.getSelectedWorkingSets();
                        }
                        IProject[] projects = ProjectSetExportWizard.this.mainPage.getSelectedProjects();
                        HashMap<String, TreeSet<IProject>> map = new HashMap<String, TreeSet<IProject>>();
                        IProject[] iProjectArray = projects;
                        int n = projects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                            if (provider != null) {
                                String id = provider.getID();
                                TreeSet<IProject> list = (TreeSet<IProject>)map.get(id);
                                if (list == null) {
                                    list = new TreeSet<IProject>((o1, o2) -> o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase()));
                                    map.put(id, list);
                                }
                                list.add(project);
                            }
                            ++n2;
                        }
                        UIProjectSetSerializationContext context = new UIProjectSetSerializationContext(ProjectSetExportWizard.this.getShell(), (String)filename);
                        try {
                            Throwable throwable = null;
                            Iterator iterator = null;
                            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                                if (!ProjectSetExportWizard.this.locationPage.isSaveToFileSystem()) {
                                    ProjectSetExportWizard.this.locationPage.validateEditWorkspaceFile(ProjectSetExportWizard.this.getShell());
                                }
                                XMLMemento xmlMemento = this.getXMLMementoRoot();
                                Iterator it = map.keySet().iterator();
                                monitor.beginTask(null, 1000 * map.size());
                                while (it.hasNext()) {
                                    String[] references;
                                    String id = (String)it.next();
                                    IMemento memento = xmlMemento.createChild("provider");
                                    memento.putString("id", id);
                                    Set list = (Set)map.get(id);
                                    IProject[] projectArray = list.toArray(new IProject[list.size()]);
                                    RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                                    ProjectSetCapability serializer = providerType.getProjectSetCapability();
                                    ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                                    if (serializer == null) continue;
                                    String[] stringArray = references = serializer.asReference(projectArray, (ProjectSetSerializationContext)context, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)990));
                                    int n3 = references.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        String reference = stringArray[n4];
                                        IMemento proj = memento.createChild("project");
                                        proj.putString("reference", reference);
                                        ++n4;
                                    }
                                }
                                if (workingSets != null) {
                                    IWorkingSet[] iWorkingSetArray = workingSets;
                                    int n5 = workingSets.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        IWorkingSet workingSet = iWorkingSetArray[n6];
                                        IMemento memento = xmlMemento.createChild("workingSets");
                                        workingSet.saveState(memento);
                                        ++n6;
                                    }
                                }
                                xmlMemento.save((Writer)writer);
                                result[0] = true;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                        if (!ProjectSetExportWizard.this.locationPage.isSaveToFileSystem()) {
                            try {
                                ProjectSetExportWizard.this.locationPage.refreshWorkspaceFile(monitor);
                            }
                            catch (CoreException e) {
                                // empty catch block
                            }
                        }
                        for (String id : map.keySet()) {
                            ProjectSetCapability capability;
                            RepositoryProviderType type = RepositoryProviderType.getProviderType((String)id);
                            if (type == null || (capability = type.getProjectSetCapability()) == null) continue;
                            capability.projectSetCreated(file, (ProjectSetSerializationContext)context, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10));
                        }
                        monitor.done();
                    }

                    private XMLMemento getXMLMementoRoot() {
                        try {
                            DocumentBuilder b = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
                            Document document = b.newDocument();
                            Element element = document.createElement("psf");
                            element.setAttribute("version", "2.0");
                            document.appendChild(element);
                            return new XMLMemento(document, element);
                        }
                        catch (ParserConfigurationException e) {
                            throw new Error(e.getMessage());
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block5;
                throw (Error)target;
            }
        }
        return result[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

