/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.extension.CDataObject;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.CDataProxy;
import org.eclipse.cdt.internal.core.settings.model.CDataProxyContainer;
import org.eclipse.cdt.internal.core.settings.model.CLanguageSetting;
import org.eclipse.cdt.internal.core.settings.model.ICDataScope;
import org.eclipse.cdt.internal.core.settings.model.IInternalResourceDescription;
import org.eclipse.cdt.internal.core.settings.model.IProxyFactory;
import org.eclipse.cdt.internal.core.settings.model.IProxyProvider;
import org.eclipse.cdt.internal.core.settings.model.MapProxyCache;
import org.eclipse.cdt.internal.core.settings.model.ProxyProvider;
import org.eclipse.cdt.internal.core.settings.model.ResourceDescriptionHolder;
import org.eclipse.core.runtime.IPath;

public class CFileDescription
extends CDataProxyContainer
implements ICFileDescription,
IProxyFactory,
IInternalResourceDescription {
    private PathSettingsContainer fCache;
    private ResourceDescriptionHolder fRcHolder;

    CFileDescription(CFileData data, CConfigurationDescription cfg) {
        super(data, cfg, cfg);
    }

    @Override
    public IPath getPath() {
        CResourceData data = (CResourceData)this.getData(false);
        return ResourceDescriptionHolder.normalizePath(data.getPath());
    }

    @Override
    public boolean isExcluded() {
        CConfigurationDescription cfg = (CConfigurationDescription)this.getConfiguration();
        return cfg.isExcluded(this.getPath());
    }

    @Override
    public void setExcluded(boolean excluded) {
        CConfigurationDescription cfg = (CConfigurationDescription)this.getConfiguration();
        cfg.setExcluded(this.getPath(), false, excluded);
    }

    @Override
    public void setPath(IPath path) {
        path = ResourceDescriptionHolder.normalizePath(path);
        if (this.getPath().equals((Object)path)) {
            return;
        }
        CResourceData data = (CResourceData)this.getData(true);
        data.setPath(path);
    }

    @Override
    void setData(CDataObject data) {
        super.setData(data);
        IPath cachedPath = this.getCachedPath();
        IPath newPath = ((CResourceData)data).getPath();
        if (cachedPath != null && !cachedPath.equals((Object)newPath)) {
            this.fCache.setPath(newPath, true);
        }
    }

    @Override
    public IPath getCachedPath() {
        if (this.fCache != null) {
            return this.fCache.getPath();
        }
        return null;
    }

    @Override
    public final int getType() {
        return 8;
    }

    @Override
    public void setPathContainer(PathSettingsContainer cr) {
        this.fCache = cr;
    }

    @Override
    public ICLanguageSetting getLanguageSetting() {
        CFileData data = this.getFileData(false);
        IProxyProvider provider = this.getChildrenProxyProvider();
        CLanguageData lData = data.getLanguageData();
        if (lData != null) {
            return (ICLanguageSetting)((Object)provider.getProxy(lData));
        }
        return null;
    }

    protected CFileData getFileData(boolean write) {
        return (CFileData)this.getData(write);
    }

    @Override
    protected IProxyProvider createChildProxyProvider() {
        ICDataScope scope = new ICDataScope(){

            @Override
            public CDataObject[] getChildren() {
                return new CLanguageData[]{CFileDescription.this.getFileData(false).getLanguageData()};
            }

            @Override
            public boolean isStatic() {
                return !CFileDescription.this.containsWritableData();
            }
        };
        MapProxyCache cache = new MapProxyCache();
        return new ProxyProvider(scope, cache, this);
    }

    @Override
    public CDataProxy createProxy(CDataObject data) {
        if (data instanceof CLanguageData) {
            return new CLanguageSetting((CLanguageData)data, this, (CConfigurationDescription)this.getConfiguration());
        }
        return null;
    }

    private ResourceDescriptionHolder getRcHolder() {
        if (this.fRcHolder == null) {
            this.fRcHolder = ((CConfigurationDescription)this.getConfiguration()).createHolder(this);
        }
        return this.fRcHolder;
    }

    @Override
    public ICFolderDescription getParentFolderDescription() {
        return this.getRcHolder().getParentFolderDescription();
    }

    @Override
    public PathSettingsContainer getPathContainer() {
        return this.fCache;
    }

    @Override
    public boolean canExclude(boolean exclude) {
        CConfigurationDescription cfg = (CConfigurationDescription)this.getConfiguration();
        return cfg.canExclude(this.getPath(), false, exclude);
    }

    @Override
    public String toString() {
        return this.getPath().toString();
    }
}

