/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileSet;

public interface IScope {
    public EScopeKind getKind();

    public IName getScopeName();

    public IScope getParent() throws DOMException;

    public IBinding[] find(String var1, IASTTranslationUnit var2);

    @Deprecated
    public IBinding[] find(String var1);

    public IBinding getBinding(IASTName var1, boolean var2);

    public IBinding getBinding(IASTName var1, boolean var2, IIndexFileSet var3);

    @Deprecated
    public IBinding[] getBindings(IASTName var1, boolean var2, boolean var3);

    @Deprecated
    public IBinding[] getBindings(IASTName var1, boolean var2, boolean var3, IIndexFileSet var4);

    public IBinding[] getBindings(ScopeLookupData var1);

    public static class ScopeLookupData {
        private char[] fLookupKey;
        private final IASTNode fLookupPoint;
        private final IASTTranslationUnit fTu;
        private final boolean fLookupPointIsName;
        private boolean fResolve = true;
        private boolean fPrefixLookup;
        private boolean fIgnorePointOfDeclaration;
        private boolean fArgumentDependent;
        private boolean fDeductionGuidesOnly = false;

        public ScopeLookupData(IASTName name, boolean resolve, boolean prefixLookup) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            this.fLookupPoint = name;
            this.fLookupPointIsName = true;
            this.fLookupKey = name.getLookupKey();
            this.fResolve = resolve;
            this.fPrefixLookup = prefixLookup;
            this.fTu = name.getTranslationUnit();
        }

        public ScopeLookupData(char[] name, IASTNode point) {
            this.fLookupPoint = point;
            this.fLookupPointIsName = false;
            this.fLookupKey = name;
            this.fIgnorePointOfDeclaration = false;
            if (this.fLookupPoint == null) {
                this.fTu = null;
                this.fIgnorePointOfDeclaration = true;
            } else {
                this.fTu = this.fLookupPoint.getTranslationUnit();
            }
        }

        public ScopeLookupData(char[] name, IASTTranslationUnit tu) {
            this.fLookupPoint = null;
            this.fLookupPointIsName = false;
            this.fLookupKey = name;
            this.fIgnorePointOfDeclaration = true;
            this.fTu = tu;
        }

        public final void setPrefixLookup(boolean prefixLookup) {
            this.fPrefixLookup = prefixLookup;
        }

        public final void setResolve(boolean resolve) {
            this.fResolve = resolve;
        }

        public final void setIgnorePointOfDeclaration(boolean ignorePointOfDeclaration) {
            this.fIgnorePointOfDeclaration = ignorePointOfDeclaration;
        }

        public final void setArgumentDependent(boolean argumentDependent) {
            this.fArgumentDependent = argumentDependent;
        }

        public final void setDeductionGuidesOnly(boolean deductionGuidesOnly) {
            this.fDeductionGuidesOnly = deductionGuidesOnly;
        }

        public final void setLookupKey(char[] key) {
            this.fLookupKey = key;
        }

        public final char[] getLookupKey() {
            return this.fLookupKey;
        }

        public final IASTNode getLookupPoint() {
            return this.fLookupPoint;
        }

        public final boolean isResolve() {
            return this.fResolve;
        }

        public final boolean isPrefixLookup() {
            return this.fPrefixLookup;
        }

        public final boolean isIgnorePointOfDeclaration() {
            return this.fIgnorePointOfDeclaration;
        }

        public final boolean isArgumentDependent() {
            return this.fArgumentDependent;
        }

        public final boolean isDeductionGuidesOnly() {
            return this.fDeductionGuidesOnly;
        }

        public final IIndexFileSet getIncludedFiles() {
            return this.fTu == null ? IIndexFileSet.EMPTY : this.fTu.getIndexFileSet();
        }

        public final IIndex getIndex() {
            return this.fTu == null ? null : this.fTu.getIndex();
        }

        public final IASTName getLookupName() {
            return this.fLookupPointIsName ? (IASTName)this.fLookupPoint : null;
        }

        public IASTTranslationUnit getTranslationUnit() {
            return this.fTu;
        }
    }
}

