/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox;

public class FilterBoxLocalTextCompletion {
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String LEFT_SQUARE_BRACKET = "[";
    private static final String RIGHT_SQUARE_BRACKET = "]";
    private static final String LEFT_BRACKET = "{";
    private static final String RIGHT_BRACKET = "}";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String SPACE = " ";

    public static String autocomplete(String str, Integer cursorPos) {
        boolean canComplete = FilterBoxLocalTextCompletion.canComplete(str, cursorPos);
        if (canComplete) {
            return FilterBoxLocalTextCompletion.complete(str, cursorPos);
        }
        return str;
    }

    private static boolean canComplete(String str, Integer cursorPos) {
        boolean isValid = true;
        String charAtCursor = "";
        if (cursorPos > 0) {
            charAtCursor = String.valueOf(str.charAt(cursorPos - 1));
        }
        if (str.length() > cursorPos) {
            boolean rightOK;
            String nextChar = String.valueOf(str.charAt(cursorPos));
            boolean charAtCursorOk = charAtCursor.equals(LEFT_BRACKET) || charAtCursor.equals(LEFT_PARENTHESIS) || charAtCursor.equals(LEFT_SQUARE_BRACKET) || charAtCursor.equals(DOUBLE_QUOTE) || charAtCursor.equals(SINGLE_QUOTE) || charAtCursor.equals(SPACE);
            boolean bl = rightOK = nextChar.equals(RIGHT_BRACKET) || nextChar.equals(RIGHT_PARENTHESIS) || nextChar.equals(RIGHT_SQUARE_BRACKET) || nextChar.equals(DOUBLE_QUOTE) || nextChar.equals(SINGLE_QUOTE) || nextChar.equals(SPACE);
            if (charAtCursor.equals(LEFT_BRACKET) || charAtCursor.equals(LEFT_PARENTHESIS) || charAtCursor.equals(LEFT_SQUARE_BRACKET)) {
                rightOK &= !nextChar.equals(DOUBLE_QUOTE) && !nextChar.equals(SINGLE_QUOTE);
            }
            isValid = rightOK && charAtCursorOk;
        }
        return isValid;
    }

    private static String complete(String str, Integer cursorPos) {
        String charAtCursor = "";
        if (cursorPos > 0) {
            charAtCursor = String.valueOf(str.charAt(cursorPos - 1));
        }
        return str.substring(0, cursorPos) + (switch (charAtCursor) {
            case LEFT_PARENTHESIS -> RIGHT_PARENTHESIS;
            case LEFT_BRACKET -> RIGHT_BRACKET;
            case LEFT_SQUARE_BRACKET -> RIGHT_SQUARE_BRACKET;
            case DOUBLE_QUOTE -> DOUBLE_QUOTE;
            case SINGLE_QUOTE -> SINGLE_QUOTE;
            default -> "";
        }) + str.substring(cursorPos, str.length());
    }
}

