/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.handlers.CommandLegacyActionWrapper;

public final class KeyBindingService
implements INestableKeyBindingService {
    private boolean disposed;
    private final Map<IWorkbenchSite, IKeyBindingService> nestedServices = new HashMap<IWorkbenchSite, IKeyBindingService>();
    private Set<String> enabledContextIds = Collections.EMPTY_SET;
    private final IWorkbenchPartSite workbenchPartSite;
    private final KeyBindingService parent;
    private IKeyBindingService activeService;
    private final Map<IAction, IHandlerActivation> actionToProxy = new HashMap<IAction, IHandlerActivation>();

    public KeyBindingService(IWorkbenchPartSite workbenchPartSite) {
        this(workbenchPartSite, null);
    }

    KeyBindingService(IWorkbenchPartSite workbenchPartSite, KeyBindingService parent) {
        this.workbenchPartSite = workbenchPartSite;
        this.parent = parent;
    }

    @Override
    public boolean activateKeyBindingService(IWorkbenchSite nestedSite) {
        if (this.disposed) {
            return false;
        }
        if (nestedSite == null) {
            if (this.activeService == null) {
                return false;
            }
            this.deactivateNestedService();
            return true;
        }
        IKeyBindingService service = this.nestedServices.get(nestedSite);
        if (service == this.activeService) {
            return false;
        }
        this.deactivateNestedService();
        if (service != null) {
            this.activateNestedService(service);
        }
        return true;
    }

    private void activateNestedService(IKeyBindingService service) {
        boolean haveParent;
        boolean active = false;
        boolean bl = haveParent = this.parent != null;
        if (haveParent) {
            boolean bl2 = active = this.parent.activeService == this;
            if (active) {
                this.parent.deactivateNestedService();
            }
        }
        this.activeService = service;
        if (service == null) {
            return;
        }
        if (haveParent) {
            if (active) {
                this.parent.activateNestedService(this);
            }
        } else if (this.activeService instanceof KeyBindingService) {
            EContextService cs = (EContextService)((KeyBindingService)this.activeService).workbenchPartSite.getService(EContextService.class);
            for (String id : ((KeyBindingService)this.activeService).enabledContextIds) {
                cs.activateContext(id);
            }
            IHandlerService hs = (IHandlerService)((KeyBindingService)this.activeService).workbenchPartSite.getService(IHandlerService.class);
            for (Map.Entry<IAction, IHandlerActivation> entry : ((KeyBindingService)this.activeService).actionToProxy.entrySet()) {
                hs.activateHandler(entry.getValue());
            }
        }
    }

    private void deactivateNestedService() {
        if (this.disposed) {
            return;
        }
        if (this.activeService == null) {
            return;
        }
        boolean active = false;
        if (this.parent != null) {
            if (this.parent.activeService == this) {
                active = true;
                this.parent.deactivateNestedService();
            }
        } else if (this.activeService instanceof KeyBindingService) {
            EContextService cs = (EContextService)((KeyBindingService)this.activeService).workbenchPartSite.getService(EContextService.class);
            for (String id : ((KeyBindingService)this.activeService).enabledContextIds) {
                cs.deactivateContext(id);
            }
            IHandlerService hs = (IHandlerService)((KeyBindingService)this.activeService).workbenchPartSite.getService(IHandlerService.class);
            hs.deactivateHandlers(((KeyBindingService)this.activeService).actionToProxy.values());
        }
        this.activeService = null;
        if (active) {
            this.parent.activateNestedService(this);
        }
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.deactivateNestedService();
            EContextService cs = (EContextService)this.workbenchPartSite.getService(EContextService.class);
            for (String id : this.enabledContextIds) {
                cs.deactivateContext(id);
            }
            this.enabledContextIds.clear();
            IHandlerService hs = (IHandlerService)this.workbenchPartSite.getService(IHandlerService.class);
            hs.deactivateHandlers(this.actionToProxy.values());
            this.actionToProxy.clear();
        }
    }

    @Override
    public IKeyBindingService getKeyBindingService(IWorkbenchSite nestedSite) {
        if (this.disposed) {
            return null;
        }
        if (nestedSite == null) {
            return null;
        }
        IKeyBindingService service = this.nestedServices.get(nestedSite);
        if (service == null) {
            service = nestedSite instanceof IWorkbenchPartSite ? new KeyBindingService((IWorkbenchPartSite)nestedSite, this) : new KeyBindingService(null, this);
            this.nestedServices.put(nestedSite, service);
        }
        return service;
    }

    @Override
    public String[] getScopes() {
        if (this.disposed) {
            return null;
        }
        HashSet<String> activeScopes = new HashSet<String>();
        activeScopes.addAll(this.enabledContextIds);
        if (this.activeService instanceof KeyBindingService) {
            activeScopes.addAll(((KeyBindingService)this.activeService).enabledContextIds);
        }
        return activeScopes.toArray(new String[activeScopes.size()]);
    }

    @Override
    public void registerAction(IAction action) {
        if (this.disposed) {
            return;
        }
        if (action instanceof CommandLegacyActionWrapper) {
            WorkbenchPlugin.log("Cannot register a CommandLegacyActionWrapper back into the system");
            return;
        }
        if (action instanceof CommandAction) {
            return;
        }
        this.unregisterAction(action);
        String commandId = action.getActionDefinitionId();
        if (commandId != null) {
            for (IAction registeredAction : this.actionToProxy.keySet()) {
                if (!commandId.equals(registeredAction.getActionDefinitionId())) continue;
                this.unregisterAction(registeredAction);
                break;
            }
            IHandlerService hs = (IHandlerService)this.workbenchPartSite.getService(IHandlerService.class);
            this.actionToProxy.put(action, hs.activateHandler(commandId, (IHandler)new ActionHandler(action)));
        }
    }

    @Override
    public boolean removeKeyBindingService(IWorkbenchSite nestedSite) {
        if (this.disposed) {
            return false;
        }
        IKeyBindingService service = this.nestedServices.remove(nestedSite);
        if (service == null) {
            return false;
        }
        if (service.equals(this.activeService)) {
            this.deactivateNestedService();
        }
        return true;
    }

    @Override
    public void setScopes(String[] scopes) {
        if (this.disposed) {
            return;
        }
        Set<String> oldContextIds = this.enabledContextIds;
        this.enabledContextIds = new HashSet<String>(Arrays.asList(scopes));
        EContextService cs = (EContextService)this.workbenchPartSite.getService(EContextService.class);
        this.addParents(cs, scopes);
        for (String id : oldContextIds) {
            if (this.enabledContextIds.contains(id)) continue;
            cs.deactivateContext(id);
        }
        for (String id : this.enabledContextIds) {
            if (oldContextIds.contains(id)) continue;
            cs.activateContext(id);
        }
    }

    private void addParents(EContextService cs, String[] scopes) {
        String[] stringArray = scopes;
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                Context current = cs.getContext(id);
                String parentId = current.getParentId();
                while (parentId != null && !this.enabledContextIds.contains(parentId)) {
                    this.enabledContextIds.add(parentId);
                    current = cs.getContext(parentId);
                    parentId = current.getParentId();
                }
            }
            catch (NotDefinedException e) {
                WorkbenchPlugin.log(e);
            }
            ++n2;
        }
    }

    @Override
    public void unregisterAction(IAction action) {
        if (this.disposed) {
            return;
        }
        if (action instanceof CommandLegacyActionWrapper) {
            WorkbenchPlugin.log("Cannot unregister a CommandLegacyActionWrapper out of the system");
            return;
        }
        IHandlerActivation activation = this.actionToProxy.remove(action);
        if (activation == null) {
            return;
        }
        IHandlerService hs = (IHandlerService)this.workbenchPartSite.getService(IHandlerService.class);
        hs.deactivateHandler(activation);
    }
}

