/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.codemining;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.codemining.DebugValueCodeMining;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.source.ISourceViewerExtension5;

public class DebugValueCodeMiningProvider
extends AbstractCodeMiningProvider {
    private volatile IDebugEventSetListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        if (!this.isEnabled()) {
            return CompletableFuture.completedFuture(List.of());
        }
        IDocument document = viewer.getDocument();
        if (viewer instanceof ISourceViewerExtension5 && this.listener == null) {
            DebugValueCodeMiningProvider debugValueCodeMiningProvider = this;
            synchronized (debugValueCodeMiningProvider) {
                if (this.listener == null) {
                    IDebugEventSetListener debugListener = e -> ((ISourceViewerExtension5)viewer).updateCodeMinings();
                    DebugPlugin.getDefault().addDebugEventListener(debugListener);
                    this.listener = debugListener;
                }
            }
        }
        if (!this.hasDebugRunning()) {
            return CompletableFuture.completedFuture(List.of());
        }
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<DebugValueCodeMining> res = new ArrayList<DebugValueCodeMining>();
            int line = 0;
            while (line < document.getNumberOfLines()) {
                LinkedHashMap<String, IVariable> variablesOnLine = new LinkedHashMap<String, IVariable>();
                try {
                    IRegion lineInfo = document.getLineInformation(line);
                    int offsetInLine = 0;
                    while (offsetInLine < lineInfo.getLength()) {
                        IVariable variableAtOffset = (IVariable)Adapters.adapt((Object)new TextSelection(document, lineInfo.getOffset() + offsetInLine, 0), IVariable.class);
                        if (variableAtOffset != null) {
                            try {
                                variablesOnLine.putIfAbsent(variableAtOffset.getName(), variableAtOffset);
                                offsetInLine += variableAtOffset.getName().length();
                            }
                            catch (DebugException ex) {
                                DebugUIPlugin.log(ex);
                            }
                        }
                        ++offsetInLine;
                    }
                    for (IVariable variableOnLine : variablesOnLine.values()) {
                        res.add(new DebugValueCodeMining(document, line, variableOnLine, (ICodeMiningProvider)this));
                    }
                }
                catch (BadLocationException e) {
                    DebugUIPlugin.log(e);
                }
                ++line;
            }
            return res;
        });
    }

    private boolean hasDebugRunning() {
        return Stream.of(DebugPlugin.getDefault().getLaunchManager().getLaunches()).filter(Predicate.not(ITerminate::isTerminated)).anyMatch(launch -> "debug".equals(launch.getLaunchMode()));
    }

    private boolean isEnabled() {
        return DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.ShowVariableInline");
    }

    public void dispose() {
        IDebugEventSetListener debugListener = this.listener;
        if (debugListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(debugListener);
            this.listener = null;
        }
    }
}

