/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IScalablePane;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.internal.InternalDraw2dUtils;

public class ScalableLayeredPane
extends LayeredPane
implements IScalablePane {
    private double scale = 1.0;
    private final boolean useScaledGraphics;

    public ScalableLayeredPane() {
        this(true);
    }

    public ScalableLayeredPane(boolean useScaledGraphics) {
        this.useScaledGraphics = useScaledGraphics;
    }

    @Override
    public Rectangle getClientArea(Rectangle rect) {
        return IScalablePane.IScalablePaneHelper.getClientArea(this, rectangle -> super.getClientArea((Rectangle)rectangle), rect);
    }

    @Override
    public Dimension getMinimumSize(int wHint, int hHint) {
        return IScalablePane.IScalablePaneHelper.getMinimumSize(this, (n, n2) -> super.getMinimumSize((int)n, (int)n2), wHint, hHint);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        return IScalablePane.IScalablePaneHelper.getPreferredSize(this, (n, n2) -> super.getPreferredSize((int)n, (int)n2), wHint, hHint);
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    protected void paintClientArea(Graphics graphics2) {
        IScalablePane.IScalablePaneHelper.paintClientArea(this, graphics -> super.paintClientArea((Graphics)graphics), graphics2);
    }

    @Override
    public boolean optimizeClip() {
        return super.optimizeClip();
    }

    @Override
    public void setScale(double newZoom) {
        if (this.scale == newZoom) {
            return;
        }
        this.scale = newZoom;
        this.fireMoved();
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean useScaledGraphics() {
        return this.useScaledGraphics;
    }

    @Override
    public void translateToParent(Translatable t) {
        IScalablePane.IScalablePaneHelper.translateToParent(this, t);
    }

    @Override
    public void translateFromParent(Translatable t) {
        IScalablePane.IScalablePaneHelper.translateFromParent(this, t);
    }

    @Override
    public boolean isCoordinateSystem() {
        return true;
    }

    @Override
    protected boolean useDoublePrecision() {
        return InternalDraw2dUtils.isAutoScaleEnabled();
    }
}

