/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.graph;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;

public class CompoundGraphTests {
    private static final String EDITOR = "Editor";
    private static final String SUBGRAPH_2 = "Subgraph 2";
    private static final String SUBGRAPH_1 = "Subgraph 1";

    public static CompoundDirectedGraph aaaapull(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph s1 = new Subgraph((Object)SUBGRAPH_1);
        Subgraph s2 = new Subgraph((Object)SUBGRAPH_2);
        Node r = new Node((Object)"r", s2);
        nodes.add((Object)r);
        Node t = new Node((Object)"t", s2);
        nodes.add((Object)t);
        Node a = new Node((Object)"a", s1);
        nodes.add((Object)a);
        Node b = new Node((Object)"b", s1);
        nodes.add((Object)b);
        Node e = new Node((Object)"e", s1);
        nodes.add((Object)e);
        Node j = new Node((Object)"j", s1);
        nodes.add((Object)j);
        Node m = new Node((Object)"m", s1);
        nodes.add((Object)m);
        edges.add((Object)new Edge(a, b));
        edges.add((Object)new Edge(b, e));
        edges.add((Object)new Edge(e, j));
        edges.add((Object)new Edge(m, t));
        edges.add((Object)new Edge(j, r));
        edges.add((Object)new Edge(a, r));
        edges.add((Object)new Edge((Node)s1, (Node)s2));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        graph.nodes.add((Object)s1);
        graph.nodes.add((Object)s2);
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph aaaflowEditor(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph diagram = new Subgraph((Object)EDITOR);
        nodes.add((Object)diagram);
        Subgraph flow = new Subgraph((Object)"Flow", diagram);
        nodes.add((Object)flow);
        Subgraph subflow1 = new Subgraph((Object)"Sub1", flow);
        nodes.add((Object)subflow1);
        Subgraph subflow2 = new Subgraph((Object)"Sub2", flow);
        nodes.add((Object)subflow2);
        Node a1 = new Node((Object)"a1", diagram);
        nodes.add((Object)a1);
        Node a2 = new Node((Object)"a2", subflow1);
        nodes.add((Object)a2);
        Node a3 = new Node((Object)"a3", subflow2);
        nodes.add((Object)a3);
        a3.width = 200;
        a2.width = 200;
        a1.width = 200;
        a1.outgoingOffset = 1;
        edges.add((Object)new Edge(a1, (Node)flow));
        edges.add((Object)new Edge(a1, a2));
        edges.add((Object)new Edge(a2, a3));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph chains(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph s1 = new Subgraph((Object)"S1");
        nodes.add((Object)s1);
        Subgraph s2 = new Subgraph((Object)"S2");
        nodes.add((Object)s2);
        Subgraph s3 = new Subgraph((Object)"S3");
        nodes.add((Object)s3);
        Subgraph sb = new Subgraph((Object)"SB");
        nodes.add((Object)sb);
        s1.setPadding(new Insets(10));
        s1.innerPadding = new Insets(1);
        s1.insets = new Insets(9);
        edges.add((Object)new Edge((Node)s1, (Node)s2));
        edges.add((Object)new Edge((Node)s1, (Node)sb));
        edges.add((Object)new Edge((Node)sb, (Node)s3));
        edges.add((Object)new Edge((Node)s2, (Node)s3));
        Node n0 = new Node((Object)"0", s1);
        nodes.add((Object)n0);
        Node nx = new Node((Object)"x", s1);
        nodes.add((Object)nx);
        Node n1 = new Node((Object)"1", s1);
        nodes.add((Object)n1);
        Node n2 = new Node((Object)"2", s1);
        nodes.add((Object)n2);
        edges.add((Object)new Edge(nx, n2));
        edges.add((Object)new Edge(n0, n2));
        edges.add((Object)new Edge(n1, n2));
        Node n3 = new Node((Object)"3", s2);
        nodes.add((Object)n3);
        Node n4 = new Node((Object)"4", s2);
        nodes.add((Object)n4);
        edges.add((Object)new Edge(n3, n4));
        Node n5 = new Node((Object)"5", s3);
        nodes.add((Object)n5);
        Node n6 = new Node((Object)"6", s3);
        nodes.add((Object)n6);
        edges.add((Object)new Edge(n5, n6));
        Node na = new Node((Object)"a", sb);
        nodes.add((Object)na);
        Node nb = new Node((Object)"b", sb);
        nodes.add((Object)nb);
        edges.add((Object)new Edge(na, nb));
        n1.width = 60;
        na.width = 70;
        n2.width = 70;
        n3.width = 100;
        n6.width = 64;
        n5.width = 64;
        n4.width = 150;
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph flowChart(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph diagram = new Subgraph((Object)"diagram");
        nodes.add((Object)diagram);
        Subgraph s1 = new Subgraph((Object)"s1", diagram);
        nodes.add((Object)s1);
        Subgraph s2 = new Subgraph((Object)"s2", s1);
        nodes.add((Object)s2);
        Subgraph s3 = new Subgraph((Object)"s3", s1);
        nodes.add((Object)s3);
        Subgraph s4 = new Subgraph((Object)"s4", s1);
        nodes.add((Object)s4);
        Subgraph s5 = new Subgraph((Object)"s5", s1);
        nodes.add((Object)s5);
        Subgraph s6 = new Subgraph((Object)"s6", s1);
        nodes.add((Object)s6);
        Subgraph s7 = new Subgraph((Object)"s7", s1);
        nodes.add((Object)s7);
        Subgraph s8 = new Subgraph((Object)"s8", s1);
        nodes.add((Object)s8);
        Node outer1 = new Node((Object)"asdf", diagram);
        nodes.add((Object)outer1);
        Node outer2 = new Node((Object)"asfasdf", diagram);
        nodes.add((Object)outer2);
        Node outer3 = new Node((Object)"a3", diagram);
        nodes.add((Object)outer3);
        edges.add((Object)new Edge((Node)s3, (Node)s6));
        edges.add((Object)new Edge((Node)s4, (Node)s7));
        edges.add((Object)new Edge((Node)s6, (Node)s8));
        edges.add((Object)new Edge(outer1, outer3));
        edges.add((Object)new Edge(outer3, (Node)s1));
        edges.add((Object)new Edge(outer2, (Node)s1));
        Node s2a = new Node((Object)"BMW", s2);
        nodes.add((Object)s2a);
        Node s2b = new Node((Object)"Hawking", s2);
        nodes.add((Object)s2b);
        Node s2c = new Node((Object)"Smurfy", s2);
        nodes.add((Object)s2c);
        edges.add((Object)new Edge(s2a, s2b));
        edges.add((Object)new Edge(s2a, s2c));
        Node s3a = new Node((Object)"Jammin", s3);
        nodes.add((Object)s3a);
        Node s3b = new Node((Object)"This is it", s3);
        nodes.add((Object)s3b);
        edges.add((Object)new Edge(s3a, s3b));
        nodes.add((Object)new Node((Object)"catDog", s4));
        Node s5a = new Node((Object)"a1", s5);
        nodes.add((Object)s5a);
        Node s5b = new Node((Object)"a2", s5);
        nodes.add((Object)s5b);
        edges.add((Object)new Edge(s5a, s5b));
        Node s6a = new Node((Object)"Hoop it up", s6);
        nodes.add((Object)s6a);
        Node s6b = new Node((Object)"Streeball", s6);
        nodes.add((Object)s6b);
        Node s6c = new Node((Object)"Downtown", s6);
        nodes.add((Object)s6c);
        edges.add((Object)new Edge(s6b, s6c));
        edges.add((Object)new Edge(s6a, s6b));
        Node s7a = new Node((Object)"Thing 1", s7);
        nodes.add((Object)s7a);
        Node s7b = new Node((Object)"Thing 2", s7);
        nodes.add((Object)s7b);
        edges.add((Object)new Edge(s7a, s7b));
        Node s8a = new Node((Object)"a1", s8);
        nodes.add((Object)s8a);
        Node s8b = new Node((Object)"a2", s8);
        nodes.add((Object)s8b);
        Node s8c = new Node((Object)"a3", s8);
        nodes.add((Object)s8c);
        Node s8d = new Node((Object)"a4", s8);
        nodes.add((Object)s8d);
        Node s8e = new Node((Object)"a5", s8);
        nodes.add((Object)s8e);
        edges.add((Object)new Edge(s8a, s8c));
        edges.add((Object)new Edge(s8a, s8d));
        edges.add((Object)new Edge(s8b, s8c));
        edges.add((Object)new Edge(s8b, s8e));
        edges.add((Object)new Edge(s8c, s8e));
        Node inner1 = new Node((Object)"buckyball", s1);
        nodes.add((Object)inner1);
        Node inner2 = new Node((Object)"d", s1);
        nodes.add((Object)inner2);
        Node inner3 = new Node((Object)"cheese", s1);
        nodes.add((Object)inner3);
        Node inner4 = new Node((Object)"dingleberry", s1);
        nodes.add((Object)inner4);
        Node inner5 = new Node((Object)"dinosaur", s1);
        nodes.add((Object)inner5);
        Node inner6 = new Node((Object)"foobar", s1);
        nodes.add((Object)inner6);
        Node inner7 = new Node((Object)"t30", s1);
        nodes.add((Object)inner7);
        Node inner8 = new Node((Object)"a21", s1);
        nodes.add((Object)inner8);
        Node inner9 = new Node((Object)"katarina", s1);
        nodes.add((Object)inner9);
        Node inner10 = new Node((Object)"zig zag", s1);
        nodes.add((Object)inner10);
        Node inner11 = new Node((Object)"a16", s1);
        nodes.add((Object)inner11);
        Node inner12 = new Node((Object)"a23", s1);
        nodes.add((Object)inner12);
        Node inner13 = new Node((Object)"a17", s1);
        nodes.add((Object)inner13);
        Node inner14 = new Node((Object)"a20", s1);
        nodes.add((Object)inner14);
        Node inner15 = new Node((Object)"a19", s1);
        nodes.add((Object)inner15);
        Node inner16 = new Node((Object)"a24", s1);
        nodes.add((Object)inner16);
        edges.add((Object)new Edge(inner1, inner3));
        edges.add((Object)new Edge(inner2, inner4));
        edges.add((Object)new Edge(inner2, inner3));
        edges.add((Object)new Edge(inner3, inner5));
        edges.add((Object)new Edge(inner4, inner5));
        edges.add((Object)new Edge(inner4, inner6));
        edges.add((Object)new Edge(inner6, (Node)s6));
        edges.add((Object)new Edge(inner5, inner7));
        edges.add((Object)new Edge(inner7, inner8));
        edges.add((Object)new Edge(inner8, (Node)s5));
        edges.add((Object)new Edge((Node)s3, inner9));
        edges.add((Object)new Edge((Node)s4, inner9));
        edges.add((Object)new Edge(inner9, inner10));
        edges.add((Object)new Edge((Node)s7, inner11));
        edges.add((Object)new Edge((Node)s7, inner12));
        edges.add((Object)new Edge(inner11, inner13));
        edges.add((Object)new Edge(inner11, inner14));
        edges.add((Object)new Edge(inner11, inner15));
        edges.add((Object)new Edge(inner12, inner15));
        edges.add((Object)new Edge(inner12, inner16));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph flowEditor1(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph diagram = new Subgraph((Object)EDITOR);
        nodes.add((Object)diagram);
        Subgraph flow = new Subgraph((Object)"Flow", diagram);
        nodes.add((Object)flow);
        Node a1 = new Node((Object)"a1", diagram);
        nodes.add((Object)a1);
        Node a2 = new Node((Object)"a2", diagram);
        nodes.add((Object)a2);
        Node a4 = new Node((Object)"a4", diagram);
        nodes.add((Object)a4);
        Node a5 = new Node((Object)"a5", diagram);
        nodes.add((Object)a5);
        Node a6 = new Node((Object)"a6", diagram);
        nodes.add((Object)a6);
        nodes.add((Object)new Node((Object)"a7", diagram));
        nodes.add((Object)new Node((Object)"a8", diagram));
        edges.add((Object)new Edge(a1, a2));
        edges.add((Object)new Edge(a2, a4));
        edges.add((Object)new Edge(a2, a5));
        edges.add((Object)new Edge(a2, a6));
        edges.add((Object)new Edge(a6, (Node)flow));
        Node x = new Node((Object)"x", flow);
        nodes.add((Object)x);
        Node y = new Node((Object)"y", flow);
        nodes.add((Object)y);
        edges.add((Object)new Edge(x, y));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph flowEditor2(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph diagram = new Subgraph((Object)EDITOR);
        nodes.add((Object)diagram);
        Subgraph flow = new Subgraph((Object)"Flow", diagram);
        nodes.add((Object)flow);
        Node a1 = new Node((Object)"a1", diagram);
        nodes.add((Object)a1);
        Node a2 = new Node((Object)"a2", diagram);
        nodes.add((Object)a2);
        Node a3 = new Node((Object)"a3", flow);
        nodes.add((Object)a3);
        Node a4 = new Node((Object)"a4", flow);
        nodes.add((Object)a4);
        edges.add((Object)new Edge(a1, a2));
        edges.add((Object)new Edge(a2, a4));
        edges.add((Object)new Edge(a3, a2));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph ShortestPassCase(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph p = new Subgraph((Object)"parent");
        nodes.add((Object)p);
        Node a = new Node((Object)"a", p);
        nodes.add((Object)a);
        Node b = new Node((Object)"b", p);
        nodes.add((Object)b);
        Node c = new Node((Object)"c", p);
        nodes.add((Object)c);
        Node d = new Node((Object)"d", p);
        nodes.add((Object)d);
        Node e = new Node((Object)"e", p);
        nodes.add((Object)e);
        edges.add((Object)new Edge(a, d));
        edges.add((Object)new Edge(a, c));
        edges.add((Object)new Edge(b, c));
        edges.add((Object)new Edge(b, d));
        edges.add((Object)new Edge(b, e));
        edges.add((Object)new Edge(c, d));
        edges.add((Object)new Edge(c, e));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph tangledSubgraphs(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph A = new Subgraph((Object)"Subgraph A");
        nodes.add((Object)A);
        Subgraph B = new Subgraph((Object)"Subgraph B");
        nodes.add((Object)B);
        Subgraph C = new Subgraph((Object)"Subgraph C");
        nodes.add((Object)C);
        Subgraph D = new Subgraph((Object)"Subgraph D");
        nodes.add((Object)D);
        Node a1 = new Node((Object)"a1", A);
        nodes.add((Object)a1);
        Node a2 = new Node((Object)"a2", A);
        nodes.add((Object)a2);
        edges.add((Object)new Edge(a1, a2));
        Node b1 = new Node((Object)"b1", B);
        nodes.add((Object)b1);
        Node b2 = new Node((Object)"b2", B);
        nodes.add((Object)b2);
        edges.add((Object)new Edge(b1, b2));
        Node c1 = new Node((Object)"c1", C);
        nodes.add((Object)c1);
        Node c2 = new Node((Object)"c2", C);
        nodes.add((Object)c2);
        edges.add((Object)new Edge(c1, c2));
        Node d1 = new Node((Object)"d1", D);
        nodes.add((Object)d1);
        Node d2 = new Node((Object)"d2", D);
        nodes.add((Object)d2);
        edges.add((Object)new Edge(d1, d2));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        edges.add((Object)new Edge(a1, d2));
        edges.add((Object)new Edge(d1, c2));
        edges.add((Object)new Edge(d1, b2));
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph test1(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph s1 = new Subgraph((Object)SUBGRAPH_1);
        Subgraph s2 = new Subgraph((Object)SUBGRAPH_2);
        Node n1 = new Node((Object)"1", s1);
        nodes.add((Object)n1);
        Node n2 = new Node((Object)"2", s1);
        nodes.add((Object)n2);
        Node n3 = new Node((Object)"3", s1);
        nodes.add((Object)n3);
        Node n4 = new Node((Object)"4", s2);
        nodes.add((Object)n4);
        Node n5 = new Node((Object)"5", s2);
        nodes.add((Object)n5);
        Node n6 = new Node((Object)"6", s2);
        nodes.add((Object)n6);
        Node n7 = new Node((Object)"7", s2);
        nodes.add((Object)n7);
        n1.width = 60;
        n2.width = 70;
        n3.width = 100;
        n6.width = 64;
        n5.width = 64;
        n4.width = 90;
        n7.width = 90;
        edges.add((Object)new Edge(n1, n3));
        edges.add((Object)new Edge(n2, n3));
        edges.add((Object)new Edge(n4, n5));
        edges.add((Object)new Edge(n4, n6));
        edges.add((Object)new Edge(n6, n7));
        edges.add((Object)new Edge(n5, n7));
        edges.add((Object)new Edge(n2, n5));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        graph.nodes.add((Object)s1);
        graph.nodes.add((Object)s2);
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }

    public static CompoundDirectedGraph test2(int direction) {
        NodeList nodes = new NodeList();
        EdgeList edges = new EdgeList();
        Subgraph s1 = new Subgraph((Object)SUBGRAPH_1);
        Subgraph s2 = new Subgraph((Object)SUBGRAPH_2);
        Subgraph s1_1 = new Subgraph((Object)"Subgraph 1.1", s1);
        nodes.add((Object)s1);
        nodes.add((Object)s2);
        nodes.add((Object)s1_1);
        Node n1 = new Node((Object)"1", s1);
        nodes.add((Object)n1);
        Node n2 = new Node((Object)"2", s1);
        nodes.add((Object)n2);
        Node n3 = new Node((Object)"3", s1);
        nodes.add((Object)n3);
        Node n4 = new Node((Object)"4", s2);
        nodes.add((Object)n4);
        Node n5 = new Node((Object)"5", s2);
        nodes.add((Object)n5);
        Node n6 = new Node((Object)"6", s2);
        nodes.add((Object)n6);
        Node n7 = new Node((Object)"7", s2);
        nodes.add((Object)n7);
        Node n8 = new Node((Object)"8", s1_1);
        nodes.add((Object)n8);
        n8.width = 80;
        n1.width = 60;
        n2.width = 70;
        n3.width = 100;
        n6.width = 64;
        n5.width = 64;
        n4.width = 90;
        n7.width = 90;
        edges.add((Object)new Edge(n1, n2));
        edges.add((Object)new Edge(n2, n3));
        edges.add((Object)new Edge(n1, n8));
        edges.add((Object)new Edge(n1, n5));
        edges.add((Object)new Edge(n8, n3));
        edges.add((Object)new Edge(n4, n5));
        edges.add((Object)new Edge(n4, n6));
        edges.add((Object)new Edge(n6, n7));
        edges.add((Object)new Edge(n5, n7));
        edges.add((Object)new Edge(n2, n5));
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        graph.setDirection(direction);
        graph.nodes = nodes;
        graph.edges = edges;
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        return graph;
    }
}

