/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.examples.graph;

import java.lang.reflect.Method;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.examples.graph.AbstractGraphDemo;
import org.eclipse.draw2d.examples.graph.CompoundGraphTests;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.swt.graphics.Font;

public class CompoundGraphDemo
extends AbstractGraphDemo {
    public static Figure buildGraph(CompoundDirectedGraph graph) {
        Panel contents = new Panel();
        contents.setFont(new Font(null, "Tahoma", 10, 0));
        contents.setBackgroundColor(ColorConstants.white);
        contents.setLayoutManager((LayoutManager)new XYLayout());
        for (Object element : graph.subgraphs) {
            Subgraph s = (Subgraph)element;
            CompoundGraphDemo.buildSubgraphFigure((Figure)contents, s);
        }
        graph.nodes.forEach(arg_0 -> CompoundGraphDemo.lambda$0((Figure)contents, arg_0));
        graph.edges.forEach(arg_0 -> CompoundGraphDemo.lambda$1((Figure)contents, arg_0));
        return contents;
    }

    private static void buildSubgraphFigure(Figure contents, Subgraph s) {
        Figure figure = new Figure();
        figure.setBorder((Border)new LineBorder(ColorConstants.blue, s.insets.left));
        contents.add((IFigure)figure, (Object)new Rectangle(s.x, s.y, s.width, s.height));
    }

    public static void main(String[] args) {
        new CompoundGraphDemo().run();
    }

    @Override
    protected IFigure getContents() {
        CompoundDirectedGraph graph = null;
        try {
            graph = (CompoundDirectedGraph)CompoundGraphTests.class.getMethod(graphMethod, Integer.TYPE).invoke(null, graphDirection);
        }
        catch (Exception e) {
            System.out.println("Could not build graph");
        }
        return CompoundGraphDemo.buildGraph(graph);
    }

    @Override
    protected String[] getGraphMethods() {
        Method[] methods = CompoundGraphTests.class.getMethods();
        String[] methodNames = new String[methods.length];
        int nameIndex = 0;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getReturnType().equals(CompoundDirectedGraph.class)) {
                methodNames[nameIndex] = method.getName();
                ++nameIndex;
            }
            ++n2;
        }
        return methodNames;
    }

    private static /* synthetic */ void lambda$0(Figure figure, Node n) {
        CompoundGraphDemo.buildNodeFigure(figure, n);
    }

    private static /* synthetic */ void lambda$1(Figure figure, Edge e) {
        CompoundGraphDemo.buildEdgeFigure(figure, e);
    }
}

