/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.ls.core.contentassist.ICompletionRankingProvider;
import org.eclipse.jdt.ls.core.internal.ExceptionFactory;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.ChainCompletionProposalComputer;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.JavadocCompletionProposal;
import org.eclipse.jdt.ls.core.internal.contentassist.SnippetCompletionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionContributionService;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponse;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionResponses;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.syntaxserver.ModelBasedCompletionEngine;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemOptions;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CompletionHandler {
    private static final Set<String> UNSUPPORTED_RESOURCES = Set.of("module-info.java", "package-info.java");
    static final Comparator<CompletionItem> PROPOSAL_COMPARATOR = new Comparator<CompletionItem>(){
        private final String DEFAULT_SORT_TEXT = String.valueOf(99999999);

        @Override
        public int compare(CompletionItem o1, CompletionItem o2) {
            return this.getSortText(o1).compareTo(this.getSortText(o2));
        }

        private String getSortText(CompletionItem ci) {
            return StringUtils.defaultString((String)ci.getSortText(), (String)this.DEFAULT_SORT_TEXT);
        }
    };
    static final Comparator<CompletionItem> LABEL_COMPARATOR = new Comparator<CompletionItem>(){

        @Override
        public int compare(CompletionItem o1, CompletionItem o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };
    public static CompletionProposal selectedProposal;
    private PreferenceManager manager;

    public static final CompletionOptions getDefaultCompletionOptions(PreferenceManager preferenceManager) {
        CompletionOptions completionOptions = new CompletionOptions(Boolean.TRUE, List.of(".", "@", "#", "*", " "));
        if (preferenceManager.getClientPreferences().isCompletionItemLabelDetailsSupport()) {
            CompletionItemOptions completionItemOptions = new CompletionItemOptions();
            completionItemOptions.setLabelDetailsSupport(Boolean.TRUE);
            completionOptions.setCompletionItem(completionItemOptions);
        }
        return completionOptions;
    }

    public CompletionHandler(PreferenceManager manager) {
        this.manager = manager;
    }

    public Either<List<CompletionItem>, CompletionList> completion(CompletionParams params, IProgressMonitor monitor) {
        long startTime = System.currentTimeMillis();
        CompletionList $ = null;
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
            $ = this.computeContentAssist(unit, params, monitor);
        }
        catch (OperationCanceledException ignorable) {
            monitor.setCanceled(true);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException("Problem with codeComplete for " + params.getTextDocument().getUri(), e);
            monitor.setCanceled(true);
        }
        if ($ == null) {
            $ = new CompletionList();
        }
        if ($.getItems() == null) {
            $.setItems(Collections.emptyList());
        }
        if (monitor.isCanceled()) {
            $.setIsIncomplete(true);
            JavaLanguageServerPlugin.logInfo("Completion request cancelled");
        } else {
            JavaLanguageServerPlugin.logInfo("Completion request completed");
        }
        long executionTime = System.currentTimeMillis() - startTime;
        String lastRequestId = null;
        for (CompletionItem item : $.getItems()) {
            String requestId = "";
            String proposalId = "";
            Map data = (Map)item.getData();
            if (data != null) {
                requestId = data.getOrDefault("rid", "");
                proposalId = data.getOrDefault("pid", "");
            }
            if (requestId.isEmpty() || proposalId.isEmpty()) continue;
            item.setCommand(new Command("", "java.completion.onDidSelect", Arrays.asList(requestId, proposalId)));
            if (Objects.equals(requestId, lastRequestId)) continue;
            lastRequestId = requestId;
            int pId = Integer.parseInt(proposalId);
            long rId = Long.parseLong(requestId);
            CompletionResponse completionResponse = CompletionResponses.get(rId);
            if (completionResponse == null || completionResponse.getProposals().size() <= pId) {
                JavaLanguageServerPlugin.logError("Failed to save common data for completion items.");
                continue;
            }
            completionResponse.setCommonData("COMPLETION_EXECUTION_TIME", String.valueOf(executionTime));
        }
        return Either.forRight((Object)$);
    }

    public void onDidCompletionItemSelect(String requestId, String proposalId) throws CoreException {
        Map<String, String> contributedData;
        this.triggerSignatureHelp();
        if (proposalId.isEmpty() || requestId.isEmpty()) {
            return;
        }
        int pId = Integer.parseInt(proposalId);
        long rId = Long.parseLong(requestId);
        CompletionResponse completionResponse = CompletionResponses.get(rId);
        if (completionResponse == null || completionResponse.getItems().size() <= pId || completionResponse.getProposals().size() <= pId) {
            throw ExceptionFactory.newException("Cannot get completion responses.");
        }
        CompletionProposal proposal = completionResponse.getProposals().get(pId);
        if (proposal == null) {
            selectedProposal = null;
        } else if (proposal.getKind() == 6 || proposal.getKind() == 26 || proposal.getKind() == 24) {
            selectedProposal = proposal;
        }
        CompletionItem item = completionResponse.getItems().get(pId);
        if (item == null) {
            throw ExceptionFactory.newException("Cannot get the completion item.");
        }
        String executionTime = completionResponse.getCommonData("COMPLETION_EXECUTION_TIME");
        if (executionTime != null) {
            ((Map)item.getData()).put("COMPLETION_EXECUTION_TIME", executionTime);
        }
        if ((contributedData = completionResponse.getCompletionItemData(pId)) != null) {
            ((Map)item.getData()).putAll(contributedData);
        }
        List<ICompletionRankingProvider> providers = ((CompletionContributionService)JavaLanguageServerPlugin.getCompletionContributionService()).getRankingProviders();
        for (ICompletionRankingProvider provider : providers) {
            provider.onDidCompletionItemSelect(item);
        }
    }

    private void triggerSignatureHelp() {
        String onSelectedCommand;
        if (this.manager.getPreferences().isSignatureHelpEnabled() && !(onSelectedCommand = this.manager.getClientPreferences().getCompletionItemCommand()).isEmpty() && this.manager.getClientPreferences().isExecuteClientCommandSupport()) {
            JavaLanguageServerPlugin.getInstance().getClientConnection().executeClientCommand(onSelectedCommand, new Object[0]);
        }
    }

    private CompletionList computeContentAssist(ICompilationUnit unit, CompletionParams params, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        CompletionResponses.clear();
        if (unit == null) {
            return null;
        }
        boolean completionForConstructor = false;
        if (params.getContext() != null && " ".equals(params.getContext().getTriggerCharacter()) && !(completionForConstructor = this.isCompletionForConstructor(params, unit, monitor))) {
            return null;
        }
        CompletionProposalUtils.addStaticImportsAsFavoriteImports(unit);
        ArrayList<CompletionItem> proposals = new ArrayList<CompletionItem>();
        int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), params.getPosition().getLine(), params.getPosition().getCharacter());
        CompletionProposalRequestor collector = new CompletionProposalRequestor(unit, offset, this.manager);
        collector.setAllowsRequiredProposals(2, 9, true);
        collector.setAllowsRequiredProposals(2, 23, true);
        collector.setAllowsRequiredProposals(2, 21, true);
        collector.setAllowsRequiredProposals(6, 9, true);
        collector.setAllowsRequiredProposals(6, 23, true);
        collector.setAllowsRequiredProposals(6, 22, true);
        collector.setAllowsRequiredProposals(26, 9, true);
        collector.setAllowsRequiredProposals(27, 9, true);
        collector.setAllowsRequiredProposals(1, 9, true);
        collector.setAllowsRequiredProposals(9, 9, true);
        collector.setFavoriteReferences(this.getFavoriteStaticMembers());
        if (offset > -1 && !monitor.isCanceled() && (buffer = unit.getBuffer()) != null && buffer.getLength() >= offset) {
            ProgressMonitorWrapper subMonitor = new ProgressMonitorWrapper(monitor){
                private long timeLimit;
                private final long TIMEOUT;
                {
                    this.TIMEOUT = Long.getLong("completion.timeout", 5000L);
                }

                public void beginTask(String name, int totalWork) {
                    this.timeLimit = System.currentTimeMillis() + this.TIMEOUT;
                }

                public boolean isCanceled() {
                    return super.isCanceled() || this.timeLimit <= System.currentTimeMillis();
                }
            };
            try {
                if (this.isIndexEngineEnabled()) {
                    unit.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)subMonitor);
                } else {
                    ModelBasedCompletionEngine.codeComplete(unit, offset, collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, (IProgressMonitor)subMonitor);
                }
                if (this.manager.getPreferences().isChainCompletionEnabled() && params.getContext().getTriggerKind() != CompletionTriggerKind.TriggerCharacter) {
                    ChainCompletionProposalComputer chain = new ChainCompletionProposalComputer(unit, collector, this.isSnippetStringSupported());
                    chain.computeCompletionProposals();
                }
                proposals.addAll(collector.getCompletionItems());
                if (this.isSnippetStringSupported() && !UNSUPPORTED_RESOURCES.contains(unit.getResource().getName())) {
                    proposals.addAll(SnippetCompletionProposal.getSnippets(unit, collector, (IProgressMonitor)subMonitor));
                }
                proposals.addAll(new JavadocCompletionProposal().getProposals(unit, offset, collector, (IProgressMonitor)subMonitor));
            }
            catch (OperationCanceledException e) {
                monitor.setCanceled(true);
            }
        }
        List tempProposals = proposals.stream().filter(prop -> prop.getKind() == CompletionItemKind.Keyword || prop.getKind() == CompletionItemKind.Snippet).collect(Collectors.toList());
        tempProposals.sort(LABEL_COMPARATOR);
        int newSortText = 999999999;
        int i = 0;
        while (i < tempProposals.size() - 1) {
            int tempSortText;
            CompletionItem currentItem = (CompletionItem)tempProposals.get(i);
            CompletionItem nextItem = (CompletionItem)tempProposals.get(i + 1);
            if (currentItem.getLabel().equals(nextItem.getLabel()) && (tempSortText = currentItem.getKind() == CompletionItemKind.Keyword ? Integer.parseInt(currentItem.getSortText()) - 1 : Integer.parseInt(nextItem.getSortText()) - 1) < newSortText) {
                newSortText = tempSortText;
            }
            ++i;
        }
        if (newSortText != -1) {
            String finalSortText = Integer.toString(newSortText);
            tempProposals.stream().filter(prop -> prop.getKind() == CompletionItemKind.Snippet).forEach(p -> p.setSortText(finalSortText));
        }
        proposals.sort(PROPOSAL_COMPARATOR);
        CompletionList list = new CompletionList(proposals);
        list.setIsIncomplete(!collector.isComplete() || completionForConstructor);
        if (this.manager.getClientPreferences().isCompletionListItemDefaultsSupport()) {
            list.setItemDefaults(collector.getCompletionItemDefaults());
        }
        return list;
    }

    private String[] getFavoriteStaticMembers() {
        PreferenceManager preferenceManager = JavaLanguageServerPlugin.getPreferencesManager();
        if (preferenceManager != null) {
            return preferenceManager.getPreferences().getJavaCompletionFavoriteMembers();
        }
        return new String[0];
    }

    private boolean isSnippetStringSupported() {
        return this.manager != null && this.manager.getClientPreferences() != null && this.manager.getClientPreferences().isCompletionSnippetsSupported();
    }

    private boolean isCompletionForConstructor(CompletionParams params, ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        Position pos = params.getPosition();
        int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), pos.getLine(), pos.getCharacter());
        if (offset < 4) {
            return false;
        }
        String content = unit.getSource();
        if (content == null) {
            return false;
        }
        String triggerWord = content.substring(offset - 4, offset);
        if (!"new ".equals(triggerWord)) {
            return false;
        }
        CompilationUnit root = SharedASTProviderCore.getAST((ITypeRoot)unit, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_ACTIVE_ONLY, (IProgressMonitor)monitor);
        if (root == null || monitor.isCanceled()) {
            return false;
        }
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)(offset - 4), (int)0);
        return !(node instanceof StringLiteral) && !(node instanceof SimpleName);
    }

    public boolean isIndexEngineEnabled() {
        return !JDTEnvironmentUtils.isSyntaxServer();
    }
}

