/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.log;

import com.microsoft.java.bs.core.Constants;

public class BspTraceEntity {
    private final String kind;
    private final String schemaVersion;
    private final String buildServerVersion = Constants.SERVER_VERSION;
    private final String operationName;
    private final String duration;
    private final String trace;
    private final String rootCauseMessage;

    private BspTraceEntity(Builder builder) {
        this.kind = "bsptrace";
        this.schemaVersion = "1.0";
        this.operationName = builder.operationName;
        this.duration = builder.duration;
        this.trace = builder.trace;
        this.rootCauseMessage = builder.rootCauseMessage;
    }

    public String getRootCauseMessage() {
        return this.rootCauseMessage;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public String getBuildServerVersion() {
        return this.buildServerVersion;
    }

    public String getDuration() {
        return this.duration;
    }

    public static class Builder {
        private String rootCauseMessage;
        private String trace;
        private String operationName;
        private String duration;

        public Builder rootCauseMessage(String rootCauseMessage) {
            this.rootCauseMessage = rootCauseMessage;
            return this;
        }

        public Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public BspTraceEntity build() {
            return new BspTraceEntity(this);
        }
    }
}

