/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class EmbeddedIfCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    public EmbeddedIfCleanUpCore() {
        this(Collections.emptyMap());
    }

    public EmbeddedIfCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.embedded_if");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.embedded_if")) {
            return new String[]{MultiFixMessages.EmbeddedIfCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.embedded_if")) {
            return "if (isActive && isValid) {\n  int i = 0;\n}\n\n\n";
        }
        return "if (isActive) {\n  if (isValid) {\n    int i = 0;\n  }\n}\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.embedded_if")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(IfStatement visited) {
                IfStatement innerIf;
                if (visited.getElseStatement() == null && (innerIf = ASTNodes.as(visited.getThenStatement(), IfStatement.class)) != null && innerIf.getElseStatement() == null && ASTNodes.getNbOperands(visited.getExpression()) + ASTNodes.getNbOperands(innerIf.getExpression()) < 5) {
                    if (!(visited.getThenStatement() instanceof Block) && !(innerIf.getThenStatement() instanceof Block)) {
                        return true;
                    }
                    rewriteOperations.add(new EmbeddedIfOperation(visited, innerIf));
                    return false;
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.EmbeddedIfCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class EmbeddedIfOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final IfStatement visited;
        private final IfStatement innerIf;

        public EmbeddedIfOperation(IfStatement visited, IfStatement innerIf) {
            this.visited = visited;
            this.innerIf = innerIf;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.EmbeddedIfCleanup_description, cuRewrite);
            InfixExpression infixExpression = ast.newInfixExpression();
            infixExpression.setLeftOperand(ASTNodeFactory.parenthesizeIfNeeded(ast, ASTNodes.createMoveTarget(rewrite, this.visited.getExpression())));
            infixExpression.setOperator(InfixExpression.Operator.CONDITIONAL_AND);
            infixExpression.setRightOperand(ASTNodeFactory.parenthesizeIfNeeded(ast, ASTNodes.createMoveTarget(rewrite, this.innerIf.getExpression())));
            Statement visitedNode = this.visited.getThenStatement() instanceof Block ? this.visited.getThenStatement() : this.visited.getExpression();
            int offset = this.visited.getThenStatement() instanceof Block ? 1 : this.visited.getExpression().getLength();
            List<Comment> visitedLineComments = ASTNodes.getTrailingLineComments((ASTNode)visitedNode, offset);
            if (!visitedLineComments.isEmpty()) {
                Statement statement;
                String tab_option;
                IJavaProject project;
                Statement innerNode = this.innerIf.getThenStatement() instanceof Block ? this.innerIf.getThenStatement() : this.innerIf.getExpression();
                int innerOffset = this.innerIf.getThenStatement() instanceof Block ? 1 : this.visited.getExpression().getLength();
                List<Comment> innerComments = ASTNodes.getTrailingLineComments((ASTNode)innerNode, innerOffset);
                StringBuilder blockBuilder = new StringBuilder("{");
                CompilationUnit root = cuRewrite.getRoot();
                IBuffer buffer = cuRewrite.getCu().getBuffer();
                this.appendComments(innerComments, blockBuilder, buffer);
                this.appendComments(visitedLineComments, blockBuilder, buffer);
                blockBuilder.append("\n");
                Object fIndent = "\t";
                IJavaElement rootElement = root.getJavaElement();
                if (rootElement != null && (project = rootElement.getJavaProject()) != null && "space".equals(tab_option = project.getOption("org.eclipse.jdt.core.formatter.tabulation.char", true))) {
                    fIndent = "";
                    int i = 0;
                    while (i < CodeFormatterUtil.getTabWidth(project)) {
                        fIndent = (String)fIndent + " ";
                        ++i;
                    }
                }
                if ((statement = this.innerIf.getThenStatement()) instanceof Block) {
                    Block innerBlock = (Block)statement;
                    ListRewrite innerBlockStmts = rewrite.getListRewrite((ASTNode)innerBlock, Block.STATEMENTS_PROPERTY);
                    List originalList = innerBlockStmts.getOriginalList();
                    for (Statement stmt : originalList) {
                        String[] textLines;
                        int startOffset = root.getExtendedStartPosition((ASTNode)stmt);
                        int endLength = root.getExtendedLength((ASTNode)stmt);
                        String text = buffer.getText(startOffset, endLength);
                        String[] stringArray = textLines = text.split("\n");
                        int n = textLines.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String textLine = stringArray[n2];
                            blockBuilder.append((String)fIndent + textLine.trim() + "\n");
                            ++n2;
                        }
                    }
                } else {
                    String[] textLines;
                    int startOffset = root.getExtendedStartPosition((ASTNode)this.innerIf.getThenStatement());
                    int endLength = root.getExtendedLength((ASTNode)this.innerIf.getThenStatement());
                    String text = buffer.getText(startOffset, endLength);
                    String[] stringArray = textLines = text.split("\n");
                    int n = textLines.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String textLine = stringArray[n3];
                        blockBuilder.append((String)fIndent + textLine.trim() + "\n");
                        ++n3;
                    }
                }
                blockBuilder.append("}");
                Block newBlock = (Block)rewrite.createStringPlaceholder(blockBuilder.toString(), 8);
                rewrite.replace((ASTNode)this.innerIf.getThenStatement(), (ASTNode)newBlock, group);
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.innerIf.getExpression(), (ASTNode)infixExpression, group);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited, (ASTNode)ASTNodes.createMoveTarget(rewrite, this.innerIf), group);
        }

        private void appendComments(List<Comment> commentList, StringBuilder buffer, IBuffer cuBuffer) {
            for (Comment innerComment : commentList) {
                if (innerComment instanceof LineComment) {
                    LineComment lineComment = (LineComment)innerComment;
                    buffer.append(" ");
                    buffer.append(cuBuffer.getText(lineComment.getStartPosition(), lineComment.getLength()));
                    continue;
                }
                if (!(innerComment instanceof BlockComment)) continue;
                BlockComment blockComment = (BlockComment)innerComment;
                buffer.append(" //");
                buffer.append(cuBuffer.getText(blockComment.getStartPosition(), blockComment.getLength() - 2));
            }
        }
    }
}

