/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ValueSource;
import org.junit.platform.commons.util.Preconditions;

class ValueArgumentsProvider
extends AnnotationBasedArgumentsProvider<ValueSource> {
    ValueArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, ValueSource valueSource) {
        Object[] arguments = this.getArgumentsFromSource(valueSource);
        return Arrays.stream(arguments).map(xva$0 -> Arguments.of(xva$0));
    }

    private Object[] getArgumentsFromSource(ValueSource valueSource) {
        List arrays = Stream.of(valueSource.shorts(), valueSource.bytes(), valueSource.ints(), valueSource.longs(), valueSource.floats(), valueSource.doubles(), valueSource.chars(), valueSource.booleans(), valueSource.strings(), valueSource.classes()).filter(array -> Array.getLength(array) > 0).collect(Collectors.toList());
        Preconditions.condition((arrays.size() == 1 ? 1 : 0) != 0, () -> "Exactly one type of input must be provided in the @" + ValueSource.class.getSimpleName() + " annotation, but there were " + arrays.size());
        Object originalArray = arrays.get(0);
        return IntStream.range(0, Array.getLength(originalArray)).mapToObj(index -> Array.get(originalArray, index)).toArray();
    }
}

