/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.RegionBasedHierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedTypeHierarchy
extends TypeHierarchy {
    protected IRegion region;

    public RegionBasedTypeHierarchy(IRegion region, ICompilationUnit[] workingCopies, IType type, boolean computeSubtypes) {
        super(type, workingCopies, (IJavaSearchScope)null, computeSubtypes);
        IJavaElement[] elements;
        Region newRegion = new Region();
        IJavaElement[] iJavaElementArray = elements = region.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            newRegion.add(element);
            ++n2;
        }
        this.region = newRegion;
        if (elements.length > 0) {
            this.project = elements[0].getJavaProject();
        }
    }

    @Override
    protected void initializeRegions() {
        IJavaElement[] roots;
        super.initializeRegions();
        IJavaElement[] iJavaElementArray = roots = this.region.getElements();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement root = iJavaElementArray[n2];
            if (root instanceof IOpenable) {
                this.files.put((IOpenable)((Object)root), new ArrayList());
            } else {
                Openable o = (Openable)((JavaElement)root).getOpenableParent();
                if (o != null) {
                    this.files.put(o, new ArrayList());
                }
            }
            this.checkCanceled();
            ++n2;
        }
    }

    @Override
    protected void compute() throws JavaModelException, CoreException {
        RegionBasedHierarchyBuilder builder = new RegionBasedHierarchyBuilder(this);
        ((HierarchyBuilder)builder).build(this.computeSubtypes);
    }

    @Override
    protected boolean isAffectedByOpenable(IJavaElementDelta delta, IJavaElement element, int eventType) {
        if (element instanceof CompilationUnit && ((CompilationUnit)element).isWorkingCopy()) {
            return super.isAffectedByOpenable(delta, element, eventType);
        }
        if (this.focusType == null) {
            return this.region.contains(element);
        }
        return super.isAffectedByOpenable(delta, element, eventType);
    }

    @Override
    public IJavaProject javaProject() {
        return this.project;
    }

    public void pruneDeadBranches() {
        this.pruneDeadBranches(this.getRootClasses());
        this.pruneDeadBranches(this.getRootInterfaces());
    }

    private boolean pruneDeadBranches(IType type) {
        Set subtypes = (Set)this.typeToSubtypes.get(type);
        if (subtypes == null) {
            return true;
        }
        this.pruneDeadBranches((IType[])subtypes.toArray(IType[]::new));
        subtypes = (Set)this.typeToSubtypes.get(type);
        return subtypes == null || subtypes.size() == 0;
    }

    private void pruneDeadBranches(IType[] types) {
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (this.pruneDeadBranches(type) && !this.region.contains(type)) {
                this.removeType(type);
            }
            ++n2;
        }
    }

    protected void removeType(IType type) {
        IType[] superinterfaces;
        Set types;
        IType superclass;
        IType[] subtypes = this.getSubtypes(type);
        this.typeToSubtypes.remove(type);
        if (subtypes != null) {
            IType[] iTypeArray = subtypes;
            int n = subtypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType subtype = iTypeArray[n2];
                this.removeType(subtype);
                ++n2;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.remove(type)) != null && (types = (Set)this.typeToSubtypes.get(superclass)) != null) {
            types.remove(type);
        }
        if ((superinterfaces = (IType[])this.typeToSuperInterfaces.remove(type)) != null) {
            IType[] iTypeArray = superinterfaces;
            int n = superinterfaces.length;
            int n3 = 0;
            while (n3 < n) {
                IType superinterface = iTypeArray[n3];
                Set types2 = (Set)this.typeToSubtypes.get(superinterface);
                if (types2 != null) {
                    types2.remove(type);
                }
                ++n3;
            }
        }
        this.interfaces.remove(type);
    }
}

