/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.ContextFinder;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceObjectsImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.eclipse.osgi.internal.serviceregistry.ShrinkableCollection;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.FindHook;
import org.osgi.resource.Capability;

public class BundleContextImpl
implements BundleContext,
EventDispatcher<Object, Object, Object> {
    private volatile boolean valid;
    final EquinoxBundle bundle;
    final EquinoxContainer container;
    final Debug debug;
    private HashMap<ServiceRegistrationImpl<?>, ServiceUse<?>> servicesInUse;
    private BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleContextImpl(EquinoxBundle bundle, EquinoxContainer container) {
        this.bundle = bundle;
        this.container = container;
        this.debug = container.getConfiguration().getDebug();
        this.valid = true;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceRegistry registry = this.container.getServiceRegistry();
        registry.removeAllServiceListeners(this);
        this.container.getEventPublisher().removeAllListeners(this);
        registry.unregisterServices(this);
        registry.releaseServicesInUse(this);
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
    }

    @Override
    public String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return this.container.getConfiguration().getProperty(key);
    }

    @Override
    public Bundle getBundle() {
        return this.getBundleImpl();
    }

    public EquinoxBundle getBundleImpl() {
        return this.bundle;
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    @Override
    public Bundle installBundle(String location, InputStream in) throws BundleException {
        this.checkValid();
        BundleInfo.Generation generation = this.container.getStorage().install(this.bundle.getModule(), location, in);
        return generation.getRevision().getBundle();
    }

    @Override
    public Bundle getBundle(long id) {
        Module m = this.container.getStorage().getModuleContainer().getModule(id);
        if (m == null) {
            return null;
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(1);
        bundles.add(m.getBundle());
        this.notifyFindHooks(this, bundles);
        if (bundles.isEmpty()) {
            return null;
        }
        return m.getBundle();
    }

    @Override
    public Bundle getBundle(String location) {
        Module m = this.container.getStorage().getModuleContainer().getModule(location);
        return m == null ? null : m.getBundle();
    }

    @Override
    public Bundle[] getBundles() {
        List<Module> modules = this.container.getStorage().getModuleContainer().getModules();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(modules.size());
        for (Module module : modules) {
            bundles.add(module.getBundle());
        }
        this.notifyFindHooks(this, bundles);
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    private void notifyFindHooks(final BundleContextImpl context, List<Bundle> allBundles) {
        if (context.getBundleImpl().getBundleId() == 0L) {
            allBundles = new ArrayList<Bundle>(allBundles);
        }
        final ShrinkableCollection<Bundle> shrinkable = new ShrinkableCollection<Bundle>((Collection<Bundle>)allBundles);
        if (System.getSecurityManager() == null) {
            this.notifyFindHooksPriviledged(context, shrinkable);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    BundleContextImpl.this.notifyFindHooksPriviledged(context, shrinkable);
                    return null;
                }
            });
        }
    }

    void notifyFindHooksPriviledged(BundleContextImpl context, Collection<Bundle> allBundles) {
        ServiceRegistry sr;
        if (this.debug.DEBUG_HOOKS) {
            this.debug.trace("org.eclipse.osgi/debug/events", "notifyBundleFindHooks(" + allBundles + ")");
        }
        if ((sr = this.container.getServiceRegistry()) == null) {
            allBundles.clear();
        } else {
            sr.notifyHooksPrivileged(FindHook.class, "find", (hook, hookRegistration) -> hook.find(context, allBundles));
        }
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.container.getServiceRegistry().addServiceListener(this, listener, filter);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        try {
            this.addServiceListener(listener, null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        if (!this.isValid()) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.container.getServiceRegistry().removeServiceListener(this, listener);
    }

    @Override
    public void addBundleListener(BundleListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            this.debug.trace("org.eclipse.osgi/debug/events", "addBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().addBundleListener(listener, this);
    }

    @Override
    public void removeBundleListener(BundleListener listener) {
        if (!this.isValid()) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            this.debug.trace("org.eclipse.osgi/debug/events", "removeBundleListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().removeBundleListener(listener, this);
    }

    @Override
    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValid();
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            this.debug.trace("org.eclipse.osgi/debug/events", "addFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().addFrameworkListener(listener, this);
    }

    @Override
    public void removeFrameworkListener(FrameworkListener listener) {
        if (!this.isValid()) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.debug.DEBUG_EVENTS) {
            String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
            this.debug.trace("org.eclipse.osgi/debug/events", "removeFrameworkListener[" + this.bundle + "](" + listenerName + ")");
        }
        this.container.getEventPublisher().removeFrameworkListener(listener, this);
    }

    @Override
    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        this.checkValid();
        return this.container.getServiceRegistry().registerService(this, clazzes, service, properties);
    }

    @Override
    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        String[] clazzes = new String[]{clazz};
        return this.registerService(clazzes, service, properties);
    }

    @Override
    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.container.getServiceRegistry().getServiceReferences(this, clazz, filter, false);
    }

    @Override
    public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValid();
        return this.container.getServiceRegistry().getServiceReferences(this, clazz, filter, true);
    }

    @Override
    public ServiceReference<?> getServiceReference(String clazz) {
        this.checkValid();
        return this.container.getServiceRegistry().getServiceReference(this, clazz);
    }

    @Override
    public <S> S getService(ServiceReference<S> reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        this.provisionServicesInUseMap();
        Object service = this.container.getServiceRegistry().getService(this, (ServiceReferenceImpl)reference);
        return service;
    }

    @Override
    public boolean ungetService(ServiceReference<?> reference) {
        if (!this.isValid()) {
            return false;
        }
        return this.container.getServiceRegistry().ungetService(this, (ServiceReferenceImpl)reference);
    }

    @Override
    public File getDataFile(String filename) {
        this.checkValid();
        BundleInfo.Generation generation = (BundleInfo.Generation)this.bundle.getModule().getCurrentRevision().getRevisionInfo();
        return generation.getBundleInfo().getDataFile(filename);
    }

    protected void start() throws BundleException {
        long start = 0L;
        try {
            if (this.debug.DEBUG_BUNDLE_TIME) {
                start = System.currentTimeMillis();
            }
            this.activator = this.loadBundleActivator();
            if (this.debug.DEBUG_BUNDLE_TIME) {
                this.debug.trace("org.eclipse.osgi/debug/bundleTime", String.valueOf(System.currentTimeMillis() - start) + " ms to load the activator of " + this.bundle);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new BundleException(String.valueOf(Msg.BundleContextImpl_LoadActivatorError) + ' ' + this.bundle, 5, e);
        }
        if (this.activator != null) {
            try {
                try {
                    this.startActivator(this.activator);
                }
                catch (BundleException be) {
                    this.activator = null;
                    throw be;
                }
            }
            finally {
                if (this.debug.DEBUG_BUNDLE_TIME) {
                    this.debug.trace("org.eclipse.osgi/debug/bundleTime", String.valueOf(System.currentTimeMillis() - start) + " ms to load and start the activator of " + this.bundle);
                }
            }
        }
    }

    private BundleActivator loadBundleActivator() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ModuleWiring wiring = this.bundle.getModule().getCurrentRevision().getWiring();
        if (wiring == null) {
            return null;
        }
        BundleLoader loader = (BundleLoader)wiring.getModuleLoader();
        if (loader == null) {
            return null;
        }
        List<Capability> metadata = wiring.getRevision().getCapabilities("equinox.module.data");
        if (metadata.isEmpty()) {
            return null;
        }
        String activatorName = (String)metadata.get(0).getAttributes().get("activator");
        if (activatorName == null) {
            return null;
        }
        Class<?> activatorClass = loader.findClass(activatorName);
        return (BundleActivator)activatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private void startActivator(final BundleActivator bundleActivator) throws BundleException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    if (bundleActivator != null) {
                        Object previousTCCL = BundleContextImpl.this.setContextFinder();
                        try {
                            bundleActivator.start(BundleContextImpl.this);
                        }
                        finally {
                            if (previousTCCL != Boolean.FALSE) {
                                Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            if (this.debug.DEBUG_GENERAL) {
                this.debug.traceThrowable("org.eclipse.osgi/debug", t2);
            }
            String clazz = null;
            clazz = bundleActivator.getClass().getName();
            throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, clazz, "start", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()), 5, t2);
        }
    }

    Object setContextFinder() {
        ContextFinder contextFinder;
        if (!this.container.getConfiguration().BUNDLE_SET_TCCL) {
            return Boolean.FALSE;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader previousTCCL = currentThread.getContextClassLoader();
        if (previousTCCL != (contextFinder = this.container.getContextFinder())) {
            try {
                currentThread.setContextClassLoader(this.container.getContextFinder());
                return previousTCCL;
            }
            catch (RuntimeException e) {
                if (this.debug.DEBUG_GENERAL) {
                    this.debug.traceThrowable("org.eclipse.osgi/debug", e);
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    protected void stop() throws BundleException {
        try {
            try {
                final BundleActivator bundleActivator = this.activator;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        if (bundleActivator != null) {
                            Object previousTCCL = BundleContextImpl.this.setContextFinder();
                            try {
                                bundleActivator.stop(BundleContextImpl.this);
                            }
                            finally {
                                if (previousTCCL != Boolean.FALSE) {
                                    Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                                }
                            }
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                if (this.debug.DEBUG_GENERAL) {
                    this.debug.traceThrowable("org.eclipse.osgi/debug", t2);
                }
                String clazz = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, clazz, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()), 5, t2);
            }
        }
        finally {
            this.activator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServiceRegistrationImpl<?>, ServiceUse<?>> getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provisionServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
    }

    @Override
    public void dispatchEvent(Object originalListener, Object l, int action, Object object) {
        block17: {
            Object previousTCCL = this.setContextFinder();
            try {
                try {
                    if (!this.isValid() && this.bundle.getBundleId() != 0L) break block17;
                    switch (action) {
                        case 1: 
                        case 2: {
                            BundleListener listener = (BundleListener)l;
                            if (this.debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                                this.debug.trace("org.eclipse.osgi/debug/events", "dispatchBundleEvent[" + this.bundle + "](" + listenerName + ")");
                            }
                            listener.bundleChanged((BundleEvent)object);
                            break;
                        }
                        case 3: {
                            ServiceEvent event = (ServiceEvent)object;
                            ServiceListener listener = (ServiceListener)l;
                            if (this.debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                                this.debug.trace("org.eclipse.osgi/debug/events", "dispatchServiceEvent[" + this.bundle + "](" + listenerName + ")");
                            }
                            listener.serviceChanged(event);
                            break;
                        }
                        case 4: {
                            FrameworkListener listener = (FrameworkListener)l;
                            if (this.debug.DEBUG_EVENTS) {
                                String listenerName = String.valueOf(listener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(listener));
                                this.debug.trace("org.eclipse.osgi/debug/events", "dispatchFrameworkEvent[" + this.bundle + "](" + listenerName + ")");
                            }
                            listener.frameworkEvent((FrameworkEvent)object);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                catch (Throwable t) {
                    if (this.debug.DEBUG_EVENTS) {
                        this.debug.trace("org.eclipse.osgi/debug/events", "Exception in bottom level event dispatcher: " + t.getMessage());
                        this.debug.traceThrowable("org.eclipse.osgi/debug/events", t);
                    }
                    if (action != 4 || ((FrameworkEvent)object).getType() != 2) {
                        this.container.getEventPublisher().publishFrameworkEvent(2, this.bundle, t);
                    }
                    if (previousTCCL != Boolean.FALSE) {
                        Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                    }
                }
            }
            finally {
                if (previousTCCL != Boolean.FALSE) {
                    Thread.currentThread().setContextClassLoader((ClassLoader)previousTCCL);
                }
            }
        }
    }

    @Override
    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return FilterImpl.newInstance(filter);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(String.valueOf(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION) + ' ' + this.bundle);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ServiceRegistration<?> registration = this.registerService(clazz.getName(), service, properties);
        return registration;
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        ServiceRegistration<?> registration = this.registerService(clazz.getName(), factory, properties);
        return registration;
    }

    @Override
    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        ServiceReference<?> reference = this.getServiceReference(clazz.getName());
        return reference;
    }

    @Override
    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference<?>[] refs = this.getServiceReferences(clazz.getName(), filter);
        if (refs == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceReference<S>> result = new ArrayList<ServiceReference<S>>(refs.length);
        Collections.addAll(result, refs);
        return result;
    }

    public EquinoxContainer getContainer() {
        return this.container;
    }

    @Override
    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        this.checkValid();
        if (reference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        this.provisionServicesInUseMap();
        ServiceObjectsImpl serviceObjects = this.container.getServiceRegistry().getServiceObjects(this, (ServiceReferenceImpl)reference);
        return serviceObjects;
    }
}

