/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.cleanup;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.cleanup.ISimpleCleanUp;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEdit;

public class OrganizeImportsCleanup
implements ISimpleCleanUp {
    @Override
    public Collection<String> getIdentifiers() {
        return List.of("organizeImports");
    }

    @Override
    public ICleanUpFix createFix(final CleanUpContext context) throws CoreException {
        CompilationUnit unit = context.getAST();
        if (unit == null) {
            return null;
        }
        OrganizeImportsOperation op = new OrganizeImportsOperation(context.getCompilationUnit(), unit, false, false, true, null, false);
        final TextEdit te = op.createTextEdit((IProgressMonitor)new NullProgressMonitor());
        return new ICleanUpFix(){

            public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
                CompilationUnitChange change = new CompilationUnitChange("", context.getCompilationUnit());
                change.setEdit(te);
                return change;
            }
        };
    }

    @Override
    public List<String> getRequiredCompilerMarkers() {
        return Collections.emptyList();
    }
}

