/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.TypeDataBase;

public class JNIid
extends VMObject {
    private static MetadataField holder;
    private static AddressField next;
    private static CIntegerField offset;
    private static MetadataField resolvedMethod;
    private static MetadataField resolvedReceiver;
    private ObjectHeap heap;

    private static synchronized void initialize(TypeDataBase db) {
    }

    public JNIid(Address addr, ObjectHeap heap) {
        super(addr);
        this.heap = heap;
    }

    public JNIid next() {
        Address nextAddr = next.getValue(this.addr);
        if (nextAddr == null) {
            return null;
        }
        return new JNIid(nextAddr, this.heap);
    }

    public Klass holder() {
        return (Klass)holder.getValue(this.addr);
    }

    public int offset() {
        return (int)offset.getValue(this.addr);
    }

    public Method method() {
        return ((InstanceKlass)this.holder()).getMethods().at(this.offset());
    }

    public Method resolvedMethod() {
        return (Method)resolvedMethod.getValue(this.addr);
    }

    public Klass resolvedReceiver() {
        return (Klass)resolvedReceiver.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                JNIid.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

