/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

import sun.jvm.hotspot.debugger.UnalignedAddressException;

public class DebuggerUtilities {
    protected long addressSize;
    protected boolean isBigEndian;

    public DebuggerUtilities(long addressSize, boolean isBigEndian) {
        this.addressSize = addressSize;
        this.isBigEndian = isBigEndian;
    }

    public String addressValueToString(long address) {
        StringBuffer buf = new StringBuffer();
        buf.append("0x");
        String val = this.addressSize == 8L ? Long.toHexString(address) : Integer.toHexString((int)address);
        int i = 0;
        while ((long)i < 2L * this.addressSize - (long)val.length()) {
            buf.append('0');
            ++i;
        }
        buf.append(val);
        return buf.toString();
    }

    public void checkAlignment(long address, long alignment) {
        if (address % alignment != 0L) {
            throw new UnalignedAddressException("Trying to read at address: " + this.addressValueToString(address) + " with alignment: " + alignment, address);
        }
    }

    public long scanAddress(String addrStr) throws NumberFormatException {
        String s = addrStr.trim();
        if (!s.startsWith("0x")) {
            throw new NumberFormatException(addrStr);
        }
        long l = 0L;
        for (int i = 2; i < s.length(); ++i) {
            int val = this.charToNibble(s.charAt(i));
            l <<= 4;
            l |= (long)val;
        }
        return l;
    }

    public int charToNibble(char ascii) throws NumberFormatException {
        if (ascii >= '0' && ascii <= '9') {
            return ascii - 48;
        }
        if (ascii >= 'A' && ascii <= 'F') {
            return 10 + ascii - 65;
        }
        if (ascii >= 'a' && ascii <= 'f') {
            return 10 + ascii - 97;
        }
        throw new NumberFormatException(new Character(ascii).toString());
    }

    public boolean dataToJBoolean(byte[] data, long jbooleanSize) {
        this.checkDataContents(data, jbooleanSize);
        return data[0] != 0;
    }

    public byte dataToJByte(byte[] data, long jbyteSize) {
        this.checkDataContents(data, jbyteSize);
        return data[0];
    }

    public char dataToJChar(byte[] data, long jcharSize) {
        this.checkDataContents(data, jcharSize);
        if (!this.isBigEndian) {
            this.byteSwap(data);
        }
        return (char)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
    }

    public double dataToJDouble(byte[] data, long jdoubleSize) {
        long longBits = this.dataToJLong(data, jdoubleSize);
        return Double.longBitsToDouble(longBits);
    }

    public float dataToJFloat(byte[] data, long jfloatSize) {
        int intBits = this.dataToJInt(data, jfloatSize);
        return Float.intBitsToFloat(intBits);
    }

    public int dataToJInt(byte[] data, long jintSize) {
        this.checkDataContents(data, jintSize);
        if (!this.isBigEndian) {
            this.byteSwap(data);
        }
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public long dataToJLong(byte[] data, long jlongSize) {
        this.checkDataContents(data, jlongSize);
        if (!this.isBigEndian) {
            this.byteSwap(data);
        }
        return this.rawDataToJLong(data);
    }

    public short dataToJShort(byte[] data, long jshortSize) {
        this.checkDataContents(data, jshortSize);
        if (!this.isBigEndian) {
            this.byteSwap(data);
        }
        return (short)((data[0] & 0xFF) << 8 | data[1] & 0xFF);
    }

    public long dataToCInteger(byte[] data, boolean isUnsigned) {
        this.checkDataContents(data, data.length);
        if (!this.isBigEndian) {
            this.byteSwap(data);
        }
        if (data.length < 8 && !isUnsigned && (data[0] & 0x80) != 0) {
            byte[] newData = new byte[8];
            for (int i = 0; i < 8; ++i) {
                newData[i] = 7 - i < data.length ? data[i + data.length - 8] : -1;
            }
            data = newData;
        }
        return this.rawDataToJLong(data);
    }

    public long dataToAddressValue(byte[] data) {
        this.checkDataContents(data, this.addressSize);
        if (!this.isBigEndian) {
            this.byteSwap(data);
        }
        return this.rawDataToJLong(data);
    }

    public byte[] jbooleanToData(boolean value) {
        byte[] res = new byte[]{(byte)(value ? 1 : 0)};
        return res;
    }

    public byte[] jbyteToData(byte value) {
        byte[] res = new byte[]{value};
        return res;
    }

    public byte[] jcharToData(char value) {
        byte[] res = new byte[]{(byte)(value >> 8 & 0xFF), (byte)value};
        if (!this.isBigEndian) {
            this.byteSwap(res);
        }
        return res;
    }

    public byte[] jdoubleToData(double value) {
        return this.jlongToData(Double.doubleToLongBits(value));
    }

    public byte[] jfloatToData(float value) {
        return this.jintToData(Float.floatToIntBits(value));
    }

    public byte[] jintToData(int value) {
        byte[] res = new byte[4];
        for (int i = 0; i < 4; ++i) {
            res[3 - i] = (byte)(value & 0xFF);
            value >>>= 8;
        }
        if (!this.isBigEndian) {
            this.byteSwap(res);
        }
        return res;
    }

    public byte[] jlongToData(long value) {
        byte[] res = new byte[8];
        for (int i = 0; i < 8; ++i) {
            res[7 - i] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        if (!this.isBigEndian) {
            this.byteSwap(res);
        }
        return res;
    }

    public byte[] jshortToData(short value) {
        byte[] res = new byte[]{(byte)(value >> 8 & 0xFF), (byte)value};
        if (!this.isBigEndian) {
            this.byteSwap(res);
        }
        return res;
    }

    public byte[] cIntegerToData(long longNumBytes, long value) {
        int numBytes = (int)longNumBytes;
        byte[] res = new byte[numBytes];
        for (int i = 0; i < numBytes; ++i) {
            res[numBytes - i - 1] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        if (!this.isBigEndian) {
            this.byteSwap(res);
        }
        return res;
    }

    private void checkDataContents(byte[] data, long len) {
        if (data.length != (int)len) {
            throw new InternalError("Bug in Win32Debugger");
        }
    }

    private void byteSwap(byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            int altIndex = data.length - i - 1;
            byte t = data[altIndex];
            data[altIndex] = data[i];
            data[i] = t;
        }
    }

    private long rawDataToJLong(byte[] data) {
        long addr = 0L;
        for (int i = 0; i < data.length; ++i) {
            addr <<= 8;
            addr |= (long)(data[i] & 0xFF);
        }
        return addr;
    }
}

