/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterType;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCArgument {
    private int number;
    private boolean isIn;
    public static final int NUM_REGISTER_PARAMETERS = 6;

    public SPARCArgument(int number, boolean isIn) {
        this.number = number;
        this.isIn = isIn;
    }

    int getNumber() {
        return this.number;
    }

    boolean getIsIn() {
        return this.isIn;
    }

    boolean getIsOut() {
        return !this.getIsIn();
    }

    public SPARCArgument getSuccessor() {
        return new SPARCArgument(this.getNumber() + 1, this.getIsIn());
    }

    public SPARCArgument asIn() {
        return new SPARCArgument(this.getNumber(), true);
    }

    public SPARCArgument asOut() {
        return new SPARCArgument(this.getNumber(), false);
    }

    public boolean isRegister() {
        return this.number < 6;
    }

    public SPARCRegister asRegister() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isRegister(), "must be a register argument");
        }
        return new SPARCRegister(this.getIsIn() ? SPARCRegisterType.IN : SPARCRegisterType.OUT, this.getNumber());
    }
}

