/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class OutputViewer {
    private static JFrame frame;
    private static JTextArea ta;

    public static void init() {
    }

    private static void append(String string) {
        if (frame == null) {
            frame = new JFrame("JConsole: Output");
            ta = new JTextArea();
            ta.setEditable(false);
            frame.getContentPane().add(new JScrollPane(ta));
            ta.setFont(new Font("Monospaced", 1, 14));
            frame.setSize(500, 600);
            frame.setLocation(524, 168);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (JFrame.getFrames().length == 1) {
                        System.exit(0);
                    }
                }
            });
        }
        ta.append(string);
        ta.setCaretPosition(ta.getText().length());
        frame.setVisible(true);
    }

    private static void appendln(String string) {
        OutputViewer.append(string + "\n");
    }

    static {
        System.setOut(PipeListener.create("System.out"));
        System.setErr(PipeListener.create("System.err"));
    }

    private static class PipeListener
    extends Thread {
        public PrintStream ps;
        private String name;
        private PipedInputStream inPipe;
        private BufferedReader br;

        public static PrintStream create(String string) {
            return new PipeListener((String)string).ps;
        }

        private PipeListener(String string) {
            this.name = string;
            try {
                this.inPipe = new PipedInputStream();
                this.ps = new PrintStream(new PipedOutputStream(this.inPipe));
                this.br = new BufferedReader(new InputStreamReader(this.inPipe));
            }
            catch (IOException iOException) {
                OutputViewer.appendln("PipeListener<init>(" + string + "): " + iOException);
            }
            this.start();
        }

        @Override
        public void run() {
            try {
                String string;
                while ((string = this.br.readLine()) != null) {
                    OutputViewer.appendln(string);
                    try {
                        Field field = PipedInputStream.class.getDeclaredField("writeSide");
                        field.setAccessible(true);
                        field.set(this.inPipe, this);
                    }
                    catch (Exception exception) {
                        OutputViewer.appendln("PipeListener(" + this.name + ").run: " + exception);
                    }
                }
                OutputViewer.appendln("-- " + this.name + " closed --");
                this.br.close();
            }
            catch (IOException iOException) {
                OutputViewer.appendln("PipeListener(" + this.name + ").run: " + iOException);
            }
        }
    }
}

