/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface Map<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(Object var1);

    public V put(K var1, V var2);

    public V remove(Object var1);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void clear();

    public Set<K> keySet();

    public Collection<V> values();

    public Set<Entry<K, V>> entrySet();

    public boolean equals(Object var1);

    public int hashCode();

    default public V getOrDefault(Object object, V v) {
        V v2 = this.get(object);
        return v2 != null || this.containsKey(object) ? v2 : v;
    }

    default public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Objects.requireNonNull(biConsumer);
        for (Entry<K, V> entry : this.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException illegalStateException) {
                throw new ConcurrentModificationException(illegalStateException);
            }
            biConsumer.accept(k, v);
        }
    }

    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        for (Entry<K, V> entry : this.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException illegalStateException) {
                throw new ConcurrentModificationException(illegalStateException);
            }
            v = biFunction.apply(k, v);
            try {
                entry.setValue(v);
            }
            catch (IllegalStateException illegalStateException) {
                throw new ConcurrentModificationException(illegalStateException);
            }
        }
    }

    default public V putIfAbsent(K k, V v) {
        V v2 = this.get(k);
        if (v2 == null) {
            v2 = this.put(k, v);
        }
        return v2;
    }

    default public boolean remove(Object object, Object object2) {
        V v = this.get(object);
        if (!Objects.equals(v, object2) || v == null && !this.containsKey(object)) {
            return false;
        }
        this.remove(object);
        return true;
    }

    default public boolean replace(K k, V v, V v2) {
        V v3 = this.get(k);
        if (!Objects.equals(v3, v) || v3 == null && !this.containsKey(k)) {
            return false;
        }
        this.put(k, v2);
        return true;
    }

    default public V replace(K k, V v) {
        V v2 = this.get(k);
        if (v2 != null || this.containsKey(k)) {
            v2 = this.put(k, v);
        }
        return v2;
    }

    default public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        V v;
        Objects.requireNonNull(function);
        V v2 = this.get(k);
        if (v2 == null && (v = function.apply(k)) != null) {
            this.put(k, v);
            return v;
        }
        return v2;
    }

    default public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        V v = this.get(k);
        if (v != null) {
            V v2 = biFunction.apply(k, v);
            if (v2 != null) {
                this.put(k, v2);
                return v2;
            }
            this.remove(k);
            return null;
        }
        return null;
    }

    default public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Objects.requireNonNull(biFunction);
        V v = this.get(k);
        V v2 = biFunction.apply(k, v);
        if (v2 == null) {
            if (v != null || this.containsKey(k)) {
                this.remove(k);
                return null;
            }
            return null;
        }
        this.put(k, v2);
        return v2;
    }

    default public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v2;
        Objects.requireNonNull(biFunction);
        Objects.requireNonNull(v);
        V v3 = this.get(k);
        V v4 = v2 = v3 == null ? v : biFunction.apply(v3, v);
        if (v2 == null) {
            this.remove(k);
        } else {
            this.put(k, v2);
        }
        return v2;
    }

    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();

        public V setValue(V var1);

        public boolean equals(Object var1);

        public int hashCode();

        public static <K extends Comparable<? super K>, V> Comparator<Entry<K, V>> comparingByKey() {
            return (Comparator & Serializable)(entry, entry2) -> ((Comparable)entry.getKey()).compareTo(entry2.getKey());
        }

        public static <K, V extends Comparable<? super V>> Comparator<Entry<K, V>> comparingByValue() {
            return (Comparator & Serializable)(entry, entry2) -> ((Comparable)entry.getValue()).compareTo(entry2.getValue());
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByKey(Comparator<? super K> comparator) {
            Objects.requireNonNull(comparator);
            return (Comparator & Serializable)(entry, entry2) -> comparator.compare((Object)entry.getKey(), (Object)entry2.getKey());
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByValue(Comparator<? super V> comparator) {
            Objects.requireNonNull(comparator);
            return (Comparator & Serializable)(entry, entry2) -> comparator.compare((Object)entry.getValue(), (Object)entry2.getValue());
        }
    }
}

