/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractAclFileAttributeView;
import sun.nio.fs.SolarisNativeDispatcher;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;

class SolarisAclFileAttributeView
extends AbstractAclFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int MAX_ACL_ENTRIES = 1024;
    private static final short SIZEOF_ACE_T = 12;
    private static final short OFFSETOF_UID = 0;
    private static final short OFFSETOF_MASK = 4;
    private static final short OFFSETOF_FLAGS = 8;
    private static final short OFFSETOF_TYPE = 10;
    private final UnixPath file;
    private final boolean followLinks;

    SolarisAclFileAttributeView(UnixPath unixPath, boolean bl) {
        this.file = unixPath;
        this.followLinks = bl;
    }

    private void checkAccess(UnixPath unixPath, boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                unixPath.checkRead();
            }
            if (bl2) {
                unixPath.checkWrite();
            }
            securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encode(List<AclEntry> list, long l) {
        long l2 = l;
        for (AclEntry aclEntry : list) {
            Set<AclEntryFlag> set;
            int n;
            int n2;
            int n3 = 0;
            UserPrincipal userPrincipal = aclEntry.principal();
            if (!(userPrincipal instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            UnixUserPrincipals.User user = (UnixUserPrincipals.User)userPrincipal;
            if (user.isSpecial()) {
                n2 = -1;
                if (userPrincipal == UnixUserPrincipals.SPECIAL_OWNER) {
                    n3 |= 0x1000;
                } else if (userPrincipal == UnixUserPrincipals.SPECIAL_GROUP) {
                    n3 |= 0x2040;
                } else {
                    if (userPrincipal != UnixUserPrincipals.SPECIAL_EVERYONE) throw new AssertionError((Object)"Unable to map special identifier");
                    n3 |= 0x4000;
                }
            } else if (user instanceof UnixUserPrincipals.Group) {
                n2 = user.gid();
                n3 |= 0x40;
            } else {
                n2 = user.uid();
            }
            switch (aclEntry.type()) {
                case ALLOW: {
                    n = 0;
                    break;
                }
                case DENY: {
                    n = 1;
                    break;
                }
                case AUDIT: {
                    n = 2;
                    break;
                }
                case ALARM: {
                    n = 3;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unable to map ACE type");
                }
            }
            Set<AclEntryPermission> set2 = aclEntry.permissions();
            int n4 = 0;
            if (set2.contains((Object)AclEntryPermission.READ_DATA)) {
                n4 |= 1;
            }
            if (set2.contains((Object)AclEntryPermission.WRITE_DATA)) {
                n4 |= 2;
            }
            if (set2.contains((Object)AclEntryPermission.APPEND_DATA)) {
                n4 |= 4;
            }
            if (set2.contains((Object)AclEntryPermission.READ_NAMED_ATTRS)) {
                n4 |= 8;
            }
            if (set2.contains((Object)AclEntryPermission.WRITE_NAMED_ATTRS)) {
                n4 |= 0x10;
            }
            if (set2.contains((Object)AclEntryPermission.EXECUTE)) {
                n4 |= 0x20;
            }
            if (set2.contains((Object)AclEntryPermission.DELETE_CHILD)) {
                n4 |= 0x40;
            }
            if (set2.contains((Object)AclEntryPermission.READ_ATTRIBUTES)) {
                n4 |= 0x80;
            }
            if (set2.contains((Object)AclEntryPermission.WRITE_ATTRIBUTES)) {
                n4 |= 0x100;
            }
            if (set2.contains((Object)AclEntryPermission.DELETE)) {
                n4 |= 0x10000;
            }
            if (set2.contains((Object)AclEntryPermission.READ_ACL)) {
                n4 |= 0x20000;
            }
            if (set2.contains((Object)AclEntryPermission.WRITE_ACL)) {
                n4 |= 0x40000;
            }
            if (set2.contains((Object)AclEntryPermission.WRITE_OWNER)) {
                n4 |= 0x80000;
            }
            if (set2.contains((Object)AclEntryPermission.SYNCHRONIZE)) {
                n4 |= 0x100000;
            }
            if ((set = aclEntry.flags()).contains((Object)AclEntryFlag.FILE_INHERIT)) {
                n3 |= 1;
            }
            if (set.contains((Object)AclEntryFlag.DIRECTORY_INHERIT)) {
                n3 |= 2;
            }
            if (set.contains((Object)AclEntryFlag.NO_PROPAGATE_INHERIT)) {
                n3 |= 4;
            }
            if (set.contains((Object)AclEntryFlag.INHERIT_ONLY)) {
                n3 |= 8;
            }
            unsafe.putInt(l2 + 0L, n2);
            unsafe.putInt(l2 + 4L, n4);
            unsafe.putShort(l2 + 8L, (short)n3);
            unsafe.putShort(l2 + 10L, (short)n);
            l2 += 12L;
        }
    }

    private static List<AclEntry> decode(long l, int n) {
        ArrayList<AclEntry> arrayList = new ArrayList<AclEntry>(n);
        for (int i = 0; i < n; ++i) {
            long l2 = l + (long)(i * 12);
            int n2 = unsafe.getInt(l2 + 0L);
            int n3 = unsafe.getInt(l2 + 4L);
            short s = unsafe.getShort(l2 + 8L);
            short s2 = unsafe.getShort(l2 + 10L);
            UnixUserPrincipals.User user = null;
            user = (s & 0x1000) > 0 ? UnixUserPrincipals.SPECIAL_OWNER : ((s & 0x2000) > 0 ? UnixUserPrincipals.SPECIAL_GROUP : ((s & 0x4000) > 0 ? UnixUserPrincipals.SPECIAL_EVERYONE : ((s & 0x40) > 0 ? UnixUserPrincipals.fromGid(n2) : UnixUserPrincipals.fromUid(n2))));
            AclEntryType aclEntryType = null;
            switch (s2) {
                case 0: {
                    aclEntryType = AclEntryType.ALLOW;
                    break;
                }
                case 1: {
                    aclEntryType = AclEntryType.DENY;
                    break;
                }
                case 2: {
                    aclEntryType = AclEntryType.AUDIT;
                    break;
                }
                case 3: {
                    aclEntryType = AclEntryType.ALARM;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            EnumSet<AclEntryPermission> enumSet = EnumSet.noneOf(AclEntryPermission.class);
            if ((n3 & 1) > 0) {
                enumSet.add(AclEntryPermission.READ_DATA);
            }
            if ((n3 & 2) > 0) {
                enumSet.add(AclEntryPermission.WRITE_DATA);
            }
            if ((n3 & 4) > 0) {
                enumSet.add(AclEntryPermission.APPEND_DATA);
            }
            if ((n3 & 8) > 0) {
                enumSet.add(AclEntryPermission.READ_NAMED_ATTRS);
            }
            if ((n3 & 0x10) > 0) {
                enumSet.add(AclEntryPermission.WRITE_NAMED_ATTRS);
            }
            if ((n3 & 0x20) > 0) {
                enumSet.add(AclEntryPermission.EXECUTE);
            }
            if ((n3 & 0x40) > 0) {
                enumSet.add(AclEntryPermission.DELETE_CHILD);
            }
            if ((n3 & 0x80) > 0) {
                enumSet.add(AclEntryPermission.READ_ATTRIBUTES);
            }
            if ((n3 & 0x100) > 0) {
                enumSet.add(AclEntryPermission.WRITE_ATTRIBUTES);
            }
            if ((n3 & 0x10000) > 0) {
                enumSet.add(AclEntryPermission.DELETE);
            }
            if ((n3 & 0x20000) > 0) {
                enumSet.add(AclEntryPermission.READ_ACL);
            }
            if ((n3 & 0x40000) > 0) {
                enumSet.add(AclEntryPermission.WRITE_ACL);
            }
            if ((n3 & 0x80000) > 0) {
                enumSet.add(AclEntryPermission.WRITE_OWNER);
            }
            if ((n3 & 0x100000) > 0) {
                enumSet.add(AclEntryPermission.SYNCHRONIZE);
            }
            EnumSet<AclEntryFlag> enumSet2 = EnumSet.noneOf(AclEntryFlag.class);
            if ((s & 1) > 0) {
                enumSet2.add(AclEntryFlag.FILE_INHERIT);
            }
            if ((s & 2) > 0) {
                enumSet2.add(AclEntryFlag.DIRECTORY_INHERIT);
            }
            if ((s & 4) > 0) {
                enumSet2.add(AclEntryFlag.NO_PROPAGATE_INHERIT);
            }
            if ((s & 8) > 0) {
                enumSet2.add(AclEntryFlag.INHERIT_ONLY);
            }
            AclEntry aclEntry = AclEntry.newBuilder().setType(aclEntryType).setPrincipal(user).setPermissions(enumSet).setFlags(enumSet2).build();
            arrayList.add(aclEntry);
        }
        return arrayList;
    }

    private static boolean isAclsEnabled(int n) {
        try {
            long l = SolarisNativeDispatcher.fpathconf(n, 20);
            if (l == 2L) {
                return true;
            }
        }
        catch (UnixException unixException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<AclEntry> getAcl() throws IOException {
        this.checkAccess(this.file, true, false);
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            long l = unsafe.allocateMemory(12288L);
            try {
                int n2 = SolarisNativeDispatcher.facl(n, 4, 1024, l);
                assert (n2 >= 0);
                List<AclEntry> list = SolarisAclFileAttributeView.decode(l, n2);
                unsafe.freeMemory(l);
                return list;
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 89 || !SolarisAclFileAttributeView.isAclsEnabled(n)) {
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, unixException.getMessage() + " (file system does not support NFSv4 ACLs)");
                }
                unixException.rethrowAsIOException(this.file);
                List<AclEntry> list = null;
                unsafe.freeMemory(l);
                SolarisNativeDispatcher.close(n);
                return list;
                {
                    catch (Throwable throwable) {
                        unsafe.freeMemory(l);
                        throw throwable;
                    }
                }
            }
        }
        finally {
            SolarisNativeDispatcher.close(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAcl(List<AclEntry> list) throws IOException {
        this.checkAccess(this.file, false, true);
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            list = new ArrayList<AclEntry>(list);
            int n2 = list.size();
            long l = unsafe.allocateMemory(12 * n2);
            try {
                SolarisAclFileAttributeView.encode(list, l);
                SolarisNativeDispatcher.facl(n, 5, n2, l);
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 89 || !SolarisAclFileAttributeView.isAclsEnabled(n)) {
                    throw new FileSystemException(this.file.getPathForExceptionMessage(), null, unixException.getMessage() + " (file system does not support NFSv4 ACLs)");
                }
                if (unixException.errno() == 22 && n2 < 3) {
                    throw new IOException("ACL must contain at least 3 entries");
                }
                unixException.rethrowAsIOException(this.file);
            }
            finally {
                unsafe.freeMemory(l);
            }
        }
        finally {
            SolarisNativeDispatcher.close(n);
        }
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        this.checkAccess(this.file, true, false);
        try {
            UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(this.file, this.followLinks);
            return UnixUserPrincipals.fromUid(unixFileAttributes.uid());
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file);
            return null;
        }
    }

    @Override
    public void setOwner(UserPrincipal userPrincipal) throws IOException {
        this.checkAccess(this.file, true, false);
        if (!(userPrincipal instanceof UnixUserPrincipals.User)) {
            throw new ProviderMismatchException();
        }
        if (userPrincipal instanceof UnixUserPrincipals.Group) {
            throw new IOException("'owner' parameter is a group");
        }
        int n = ((UnixUserPrincipals.User)userPrincipal).uid();
        try {
            if (this.followLinks) {
                SolarisNativeDispatcher.lchown(this.file, n, -1);
            } else {
                SolarisNativeDispatcher.chown(this.file, n, -1);
            }
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file);
        }
    }
}

