/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.temporal.TemporalField;

public final class ValueRange
implements Serializable {
    private static final long serialVersionUID = -7317881728594519368L;
    private final long minSmallest;
    private final long minLargest;
    private final long maxSmallest;
    private final long maxLargest;

    public static ValueRange of(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("Minimum value must be less than maximum value");
        }
        return new ValueRange(l, l, l2, l2);
    }

    public static ValueRange of(long l, long l2, long l3) {
        return ValueRange.of(l, l, l2, l3);
    }

    public static ValueRange of(long l, long l2, long l3, long l4) {
        if (l > l2) {
            throw new IllegalArgumentException("Smallest minimum value must be less than largest minimum value");
        }
        if (l3 > l4) {
            throw new IllegalArgumentException("Smallest maximum value must be less than largest maximum value");
        }
        if (l2 > l4) {
            throw new IllegalArgumentException("Minimum value must be less than maximum value");
        }
        return new ValueRange(l, l2, l3, l4);
    }

    private ValueRange(long l, long l2, long l3, long l4) {
        this.minSmallest = l;
        this.minLargest = l2;
        this.maxSmallest = l3;
        this.maxLargest = l4;
    }

    public boolean isFixed() {
        return this.minSmallest == this.minLargest && this.maxSmallest == this.maxLargest;
    }

    public long getMinimum() {
        return this.minSmallest;
    }

    public long getLargestMinimum() {
        return this.minLargest;
    }

    public long getSmallestMaximum() {
        return this.maxSmallest;
    }

    public long getMaximum() {
        return this.maxLargest;
    }

    public boolean isIntValue() {
        return this.getMinimum() >= Integer.MIN_VALUE && this.getMaximum() <= Integer.MAX_VALUE;
    }

    public boolean isValidValue(long l) {
        return l >= this.getMinimum() && l <= this.getMaximum();
    }

    public boolean isValidIntValue(long l) {
        return this.isIntValue() && this.isValidValue(l);
    }

    public long checkValidValue(long l, TemporalField temporalField) {
        if (!this.isValidValue(l)) {
            throw new DateTimeException(this.genInvalidFieldMessage(temporalField, l));
        }
        return l;
    }

    public int checkValidIntValue(long l, TemporalField temporalField) {
        if (!this.isValidIntValue(l)) {
            throw new DateTimeException(this.genInvalidFieldMessage(temporalField, l));
        }
        return (int)l;
    }

    private String genInvalidFieldMessage(TemporalField temporalField, long l) {
        if (temporalField != null) {
            return "Invalid value for " + temporalField + " (valid values " + this + "): " + l;
        }
        return "Invalid value (valid values " + this + "): " + l;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidObjectException {
        objectInputStream.defaultReadObject();
        if (this.minSmallest > this.minLargest) {
            throw new InvalidObjectException("Smallest minimum value must be less than largest minimum value");
        }
        if (this.maxSmallest > this.maxLargest) {
            throw new InvalidObjectException("Smallest maximum value must be less than largest maximum value");
        }
        if (this.minLargest > this.maxLargest) {
            throw new InvalidObjectException("Minimum value must be less than maximum value");
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ValueRange) {
            ValueRange valueRange = (ValueRange)object;
            return this.minSmallest == valueRange.minSmallest && this.minLargest == valueRange.minLargest && this.maxSmallest == valueRange.maxSmallest && this.maxLargest == valueRange.maxLargest;
        }
        return false;
    }

    public int hashCode() {
        long l = this.minSmallest + (this.minLargest << 16) + (this.minLargest >> 48) + (this.maxSmallest << 32) + (this.maxSmallest >> 32) + (this.maxLargest << 48) + (this.maxLargest >> 16);
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.minSmallest);
        if (this.minSmallest != this.minLargest) {
            stringBuilder.append('/').append(this.minLargest);
        }
        stringBuilder.append(" - ").append(this.maxSmallest);
        if (this.maxSmallest != this.maxLargest) {
            stringBuilder.append('/').append(this.maxLargest);
        }
        return stringBuilder.toString();
    }
}

