/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import sun.java2d.marlin.MarlinConst;

public final class FloatMath
implements MarlinConst {
    static final boolean CHECK_OVERFLOW = true;
    static final boolean CHECK_NAN = true;

    private FloatMath() {
    }

    static float max(float f, float f2) {
        return f >= f2 ? f : f2;
    }

    static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static float ceil_f(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = ((n & 0x7F800000) >> 23) - 127;
        if (n2 < 0) {
            return f == 0.0f ? f : (f < 0.0f ? -0.0f : 1.0f);
        }
        if (n2 >= 23) {
            return f;
        }
        assert (n2 >= 0 && n2 <= 22);
        int n3 = n & ~(0x7FFFFF >> n2);
        if (n3 == n) {
            return f;
        }
        return Float.intBitsToFloat(n3) + (float)(~n3 >>> 31);
    }

    public static float floor_f(float f) {
        int n = Float.floatToRawIntBits(f);
        int n2 = ((n & 0x7F800000) >> 23) - 127;
        if (n2 < 0) {
            return f == 0.0f ? f : (f < 0.0f ? -1.0f : 0.0f);
        }
        if (n2 >= 23) {
            return f;
        }
        assert (n2 >= 0 && n2 <= 22);
        int n3 = n & ~(0x7FFFFF >> n2);
        if (n3 == n) {
            return f;
        }
        return Float.intBitsToFloat(n3) + (float)(n3 >> 31);
    }

    public static int ceil_int(float f) {
        int n = (int)f;
        if (f <= (float)n || n == Integer.MAX_VALUE || Float.isNaN(f)) {
            return n;
        }
        return n + 1;
    }

    public static int floor_int(float f) {
        int n = (int)f;
        if (f >= (float)n || n == Integer.MIN_VALUE || Float.isNaN(f)) {
            return n;
        }
        return n - 1;
    }
}

