/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.util.List;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.ObjectFactory;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.consumer.RecordedThreadGroup;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.Type;

public final class RecordedThread
extends RecordedObject {
    private final long uniqueId;

    static ObjectFactory<RecordedThread> createFactory(Type type, final TimeConverter timeConverter) {
        return new ObjectFactory<RecordedThread>(type){

            @Override
            RecordedThread createTyped(List<ValueDescriptor> list, long l, Object[] objectArray) {
                return new RecordedThread(list, l, objectArray, timeConverter);
            }
        };
    }

    private RecordedThread(List<ValueDescriptor> list, long l, Object[] objectArray, TimeConverter timeConverter) {
        super(list, objectArray, timeConverter);
        this.uniqueId = l;
    }

    public String getOSName() {
        return this.getTyped("osName", String.class, null);
    }

    public long getOSThreadId() {
        Long l = this.getTyped("osThreadId", Long.class, -1L);
        return l;
    }

    public RecordedThreadGroup getThreadGroup() {
        return this.getTyped("group", RecordedThreadGroup.class, null);
    }

    public String getJavaName() {
        return this.getTyped("javaName", String.class, null);
    }

    public long getJavaThreadId() {
        Long l = this.getTyped("javaThreadId", Long.class, -1L);
        return l;
    }

    public long getId() {
        return this.uniqueId;
    }
}

