/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.platform.CgroupUtil;

public interface CgroupSubsystemController {
    public static final String EMPTY_STR = "";

    public String path();

    public static String getStringValue(CgroupSubsystemController cgroupSubsystemController, String string) {
        if (cgroupSubsystemController == null) {
            return null;
        }
        try {
            return CgroupUtil.readStringValue(cgroupSubsystemController, string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static long getLongValueMatchingLine(CgroupSubsystemController cgroupSubsystemController, String string, String string2, Function<String, Long> function, long l) {
        long l2 = l;
        if (cgroupSubsystemController == null) {
            return l2;
        }
        try {
            Path path = Paths.get(cgroupSubsystemController.path(), string);
            List<String> list = CgroupUtil.readAllLinesPrivileged(path);
            for (String string3 : list) {
                if (!string3.startsWith(string2)) continue;
                l2 = function.apply(string3);
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l2;
    }

    public static long getLongValue(CgroupSubsystemController cgroupSubsystemController, String string, Function<String, Long> function, long l) {
        String string2 = CgroupSubsystemController.getStringValue(cgroupSubsystemController, string);
        if (string2 == null) {
            return l;
        }
        return function.apply(string2);
    }

    public static double getDoubleValue(CgroupSubsystemController cgroupSubsystemController, String string, double d) {
        String string2 = CgroupSubsystemController.getStringValue(cgroupSubsystemController, string);
        if (string2 == null) {
            return d;
        }
        double d2 = Double.parseDouble(string2);
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getLongEntry(CgroupSubsystemController cgroupSubsystemController, String string2, String string3, long l) {
        if (cgroupSubsystemController == null) {
            return l;
        }
        try (Stream<String> stream = CgroupUtil.readFilePrivileged(Paths.get(cgroupSubsystemController.path(), string2));){
            Optional<String> optional = stream.map(string -> string.split(" ")).filter(stringArray -> ((String[])stringArray).length == 2 && stringArray[0].equals(string3)).map(stringArray -> stringArray[1]).findFirst();
            long l2 = optional.isPresent() ? Long.parseLong(optional.get()) : l;
            return l2;
        }
        catch (UncheckedIOException uncheckedIOException) {
            return l;
        }
        catch (IOException iOException) {
            return l;
        }
    }

    public static int[] stringRangeToIntArray(String string) {
        String[] stringArray;
        if (string == null || EMPTY_STR.equals(string)) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : stringArray = string.split(",")) {
            if (string2.contains("-")) {
                String[] stringArray2 = string2.split("-");
                if (stringArray2.length != 2) continue;
                int n = Integer.parseInt(stringArray2[0]);
                int n2 = Integer.parseInt(stringArray2[1]);
                for (int i = n; i <= n2; ++i) {
                    arrayList.add(i);
                }
                continue;
            }
            arrayList.add(Integer.parseInt(string2));
        }
        arrayList.sort(null);
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        for (Integer n3 : arrayList) {
            nArray[n++] = n3;
        }
        return nArray;
    }

    public static long convertStringToLong(String string, long l, long l2) {
        long l3;
        block3: {
            l3 = l2;
            if (string == null) {
                return l3;
            }
            try {
                l3 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                BigInteger bigInteger = new BigInteger(string);
                if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) break block3;
                return l;
            }
        }
        return l3;
    }
}

