/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.util.Arrays;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;

public class OpenMBeanOperationInfoSupport
extends MBeanOperationInfo
implements OpenMBeanOperationInfo {
    static final long serialVersionUID = 4996859732565369366L;
    private OpenType<?> returnOpenType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanOperationInfoSupport(String string, String string2, OpenMBeanParameterInfo[] openMBeanParameterInfoArray, OpenType<?> openType, int n) {
        this(string, string2, openMBeanParameterInfoArray, openType, n, (Descriptor)null);
    }

    public OpenMBeanOperationInfoSupport(String string, String string2, OpenMBeanParameterInfo[] openMBeanParameterInfoArray, OpenType<?> openType, int n, Descriptor descriptor) {
        super(string, string2, OpenMBeanOperationInfoSupport.arrayCopyCast(openMBeanParameterInfoArray), openType == null ? null : openType.getClassName(), n, ImmutableDescriptor.union(descriptor, openType == null ? null : openType.getDescriptor()));
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument name cannot be null or empty");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty");
        }
        if (openType == null) {
            throw new IllegalArgumentException("Argument returnOpenType cannot be null");
        }
        if (n != 1 && n != 2 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Argument impact can only be one of ACTION, ACTION_INFO, INFO, or UNKNOWN: " + n);
        }
        this.returnOpenType = openType;
    }

    private static MBeanParameterInfo[] arrayCopyCast(OpenMBeanParameterInfo[] openMBeanParameterInfoArray) {
        if (openMBeanParameterInfoArray == null) {
            return null;
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[openMBeanParameterInfoArray.length];
        System.arraycopy(openMBeanParameterInfoArray, 0, mBeanParameterInfoArray, 0, openMBeanParameterInfoArray.length);
        return mBeanParameterInfoArray;
    }

    private static OpenMBeanParameterInfo[] arrayCopyCast(MBeanParameterInfo[] mBeanParameterInfoArray) {
        if (mBeanParameterInfoArray == null) {
            return null;
        }
        OpenMBeanParameterInfo[] openMBeanParameterInfoArray = new OpenMBeanParameterInfo[mBeanParameterInfoArray.length];
        System.arraycopy(mBeanParameterInfoArray, 0, openMBeanParameterInfoArray, 0, mBeanParameterInfoArray.length);
        return openMBeanParameterInfoArray;
    }

    @Override
    public OpenType<?> getReturnOpenType() {
        return this.returnOpenType;
    }

    @Override
    public boolean equals(Object object) {
        OpenMBeanOperationInfo openMBeanOperationInfo;
        if (object == null) {
            return false;
        }
        try {
            openMBeanOperationInfo = (OpenMBeanOperationInfo)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getName().equals(openMBeanOperationInfo.getName())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), openMBeanOperationInfo.getSignature())) {
            return false;
        }
        if (!this.getReturnOpenType().equals(openMBeanOperationInfo.getReturnOpenType())) {
            return false;
        }
        return this.getImpact() == openMBeanOperationInfo.getImpact();
    }

    @Override
    public int hashCode() {
        if (this.myHashCode == null) {
            int n = 0;
            n += this.getName().hashCode();
            n += Arrays.asList(this.getSignature()).hashCode();
            n += this.getReturnOpenType().hashCode();
            this.myHashCode = n += this.getImpact();
        }
        return this.myHashCode;
    }

    @Override
    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getName() + ",signature=" + Arrays.asList(this.getSignature()).toString() + ",return=" + this.getReturnOpenType().toString() + ",impact=" + this.getImpact() + ",descriptor=" + this.getDescriptor() + ")";
        }
        return this.myToString;
    }

    private Object readResolve() {
        if (this.getDescriptor().getFieldNames().length == 0) {
            return new OpenMBeanOperationInfoSupport(this.name, this.description, OpenMBeanOperationInfoSupport.arrayCopyCast(this.getSignature()), this.returnOpenType, this.getImpact());
        }
        return this;
    }
}

