/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyDerivationGenerator;
import sun.security.ssl.SSLLogger;

enum SSLMasterKeyDerivation implements SSLKeyDerivationGenerator
{
    SSL30("kdf_ssl30"),
    TLS10("kdf_tls10"),
    TLS12("kdf_tls12");

    final String name;

    private SSLMasterKeyDerivation(String string2) {
        this.name = string2;
    }

    static SSLMasterKeyDerivation valueOf(ProtocolVersion protocolVersion) {
        switch (protocolVersion) {
            case SSL30: {
                return SSL30;
            }
            case TLS10: 
            case TLS11: {
                return TLS10;
            }
            case TLS12: {
                return TLS12;
            }
        }
        return null;
    }

    @Override
    public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) throws IOException {
        return new LegacyMasterKeyDerivation(handshakeContext, secretKey);
    }

    private static final class LegacyMasterKeyDerivation
    implements SSLKeyDerivation {
        final HandshakeContext context;
        final SecretKey preMasterSecret;

        LegacyMasterKeyDerivation(HandshakeContext handshakeContext, SecretKey secretKey) {
            this.context = handshakeContext;
            this.preMasterSecret = secretKey;
        }

        @Override
        public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
            TlsMasterSecretParameterSpec tlsMasterSecretParameterSpec;
            Object object;
            CipherSuite.HashAlg hashAlg;
            String string2;
            CipherSuite cipherSuite = this.context.negotiatedCipherSuite;
            ProtocolVersion protocolVersion = this.context.negotiatedProtocol;
            byte by = protocolVersion.major;
            byte by2 = protocolVersion.minor;
            if (protocolVersion.id >= ProtocolVersion.TLS12.id) {
                string2 = "SunTls12MasterSecret";
                hashAlg = cipherSuite.hashAlg;
            } else {
                string2 = "SunTlsMasterSecret";
                hashAlg = CipherSuite.HashAlg.H_NONE;
            }
            if (this.context.handshakeSession.useExtendedMasterSecret) {
                string2 = "SunTlsExtendedMasterSecret";
                this.context.handshakeHash.utilize();
                object = this.context.handshakeHash.digest();
                tlsMasterSecretParameterSpec = new TlsMasterSecretParameterSpec(this.preMasterSecret, by & 0xFF, by2 & 0xFF, (byte[])object, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
            } else {
                tlsMasterSecretParameterSpec = new TlsMasterSecretParameterSpec(this.preMasterSecret, by & 0xFF, by2 & 0xFF, this.context.clientHelloRandom.randomBytes, this.context.serverHelloRandom.randomBytes, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
            }
            try {
                object = JsseJce.getKeyGenerator(string2);
                ((KeyGenerator)object).init(tlsMasterSecretParameterSpec);
                return ((KeyGenerator)object).generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                    SSLLogger.fine("RSA master secret generation error.", generalSecurityException);
                }
                throw new ProviderException(generalSecurityException);
            }
        }
    }
}

