/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    static final Log proxyLog = Log.getLog("sun.rmi.transport.tcp.proxy", "transport", logLevel);
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private static final boolean eagerHttpFallback = AccessController.doPrivileged(new GetBooleanAction("sun.rmi.transport.proxy.eagerHttpFallback"));
    private Hashtable<String, RMISocketFactory> successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector<String> hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector<RMISocketFactory> altFactoryList = new Vector(2);

    private static String getLogLevel() {
        return AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    private static long getConnectTimeout() {
        return AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    public RMIMasterSocketFactory() {
        boolean bl = false;
        try {
            boolean bl2;
            String string = AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (string == null) {
                string = AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(bl2 = AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.disableHttp", "true")).equalsIgnoreCase("true")) && string != null && string.length() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Socket createSocket(String string, int n) throws IOException {
        Object object;
        if (proxyLog.isLoggable(Log.BRIEF)) {
            proxyLog.log(Log.BRIEF, "host: " + string + ", port: " + n);
        }
        if (this.altFactoryList.size() == 0) {
            return this.initialFactory.createSocket(string, n);
        }
        RMISocketFactory rMISocketFactory = this.successTable.get(string);
        if (rMISocketFactory != null) {
            if (!proxyLog.isLoggable(Log.BRIEF)) return rMISocketFactory.createSocket(string, n);
            proxyLog.log(Log.BRIEF, "previously successful factory found: " + rMISocketFactory);
            return rMISocketFactory.createSocket(string, n);
        }
        Socket socket = null;
        Socket socket2 = null;
        AsyncConnector asyncConnector = new AsyncConnector(this.initialFactory, string, n, AccessController.getContext());
        IOException iOException = null;
        try {
            Object object2 = asyncConnector;
            // MONITORENTER : object2
            Thread thread = AccessController.doPrivileged(new NewThreadAction(asyncConnector, "AsyncConnector", true));
            thread.start();
            try {
                long l = System.currentTimeMillis();
                long l2 = l + connectTimeout;
                do {
                    asyncConnector.wait(l2 - l);
                } while ((socket = this.checkConnector(asyncConnector)) == null && (l = System.currentTimeMillis()) < l2);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException("interrupted while waiting for connector");
            }
            if (socket == null) {
                throw new NoRouteToHostException("connect timed out: " + string);
            }
            proxyLog.log(Log.BRIEF, "direct socket connection successful");
            object2 = socket;
            return object2;
        }
        catch (NoRouteToHostException | UnknownHostException iOException2) {
            iOException = iOException2;
        }
        catch (SocketException socketException) {
            if (!eagerHttpFallback) throw socketException;
            iOException = socketException;
        }
        finally {
            if (iOException != null) {
                if (proxyLog.isLoggable(Log.BRIEF)) {
                    proxyLog.log(Log.BRIEF, "direct socket connection failed: ", iOException);
                }
                for (int i = 0; i < this.altFactoryList.size(); ++i) {
                    rMISocketFactory = this.altFactoryList.elementAt(i);
                    if (proxyLog.isLoggable(Log.BRIEF)) {
                        proxyLog.log(Log.BRIEF, "trying with factory: " + rMISocketFactory);
                    }
                    try {
                        object = rMISocketFactory.createSocket(string, n);
                        Throwable throwable = null;
                        try {
                            InputStream inputStream = ((Socket)object).getInputStream();
                            int n2 = inputStream.read();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (object != null) {
                                if (throwable != null) {
                                    try {
                                        ((Socket)object).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((Socket)object).close();
                                }
                            }
                        }
                    }
                    catch (IOException iOException3) {
                        if (!proxyLog.isLoggable(Log.BRIEF)) continue;
                        proxyLog.log(Log.BRIEF, "factory failed: ", iOException3);
                        continue;
                    }
                    proxyLog.log(Log.BRIEF, "factory succeeded");
                    try {
                        socket2 = rMISocketFactory.createSocket(string, n);
                    }
                    catch (IOException iOException4) {}
                    break;
                }
            }
        }
        Hashtable<String, RMISocketFactory> hashtable = this.successTable;
        // MONITORENTER : hashtable
        try {
            object = asyncConnector;
            // MONITORENTER : object
            socket = this.checkConnector(asyncConnector);
            // MONITOREXIT : object
            if (socket != null) {
                if (socket2 != null) {
                    socket2.close();
                }
                // MONITOREXIT : hashtable
                return socket;
            }
            asyncConnector.notUsed();
        }
        catch (NoRouteToHostException | UnknownHostException iOException5) {
            iOException = iOException5;
        }
        catch (SocketException socketException) {
            if (!eagerHttpFallback) throw socketException;
            iOException = socketException;
        }
        if (socket2 == null) throw iOException;
        this.rememberFactory(string, rMISocketFactory);
        // MONITOREXIT : hashtable
        return socket2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable<String, RMISocketFactory> hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        Exception exception = asyncConnector.getException();
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("internal error: unexpected checked exception: " + exception.toString());
        }
        return asyncConnector.getSocket();
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        return this.initialFactory.createServerSocket(n);
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory rMISocketFactory, String string, int n, AccessControlContext accessControlContext) {
            this.factory = rMISocketFactory;
            this.host = string;
            this.port = n;
            this.acc = accessControlContext;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Socket socket = this.factory.createSocket(this.host, this.port);
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.socket = socket;
                    this.notify();
                }
                RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                asyncConnector = this;
                synchronized (asyncConnector) {
                    if (this.cleanUp) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.exception = exception;
                    this.notify();
                }
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

