/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import sun.awt.AWTAccessor;

public class InvocationEvent
extends AWTEvent
implements ActiveEvent {
    public static final int INVOCATION_FIRST = 1200;
    public static final int INVOCATION_DEFAULT = 1200;
    public static final int INVOCATION_LAST = 1200;
    protected Runnable runnable;
    protected volatile Object notifier;
    private final Runnable listener;
    private volatile boolean dispatched = false;
    protected boolean catchExceptions;
    private Exception exception = null;
    private Throwable throwable = null;
    private long when;
    private static final long serialVersionUID = 436056344909459450L;

    public InvocationEvent(Object object, Runnable runnable) {
        this(object, 1200, runnable, null, null, false);
    }

    public InvocationEvent(Object object, Runnable runnable, Object object2, boolean bl) {
        this(object, 1200, runnable, object2, null, bl);
    }

    public InvocationEvent(Object object, Runnable runnable, Runnable runnable2, boolean bl) {
        this(object, 1200, runnable, null, runnable2, bl);
    }

    protected InvocationEvent(Object object, int n, Runnable runnable, Object object2, boolean bl) {
        this(object, n, runnable, object2, null, bl);
    }

    private InvocationEvent(Object object, int n, Runnable runnable, Object object2, Runnable runnable2, boolean bl) {
        super(object, n);
        this.runnable = runnable;
        this.notifier = object2;
        this.listener = runnable2;
        this.catchExceptions = bl;
        this.when = System.currentTimeMillis();
    }

    @Override
    public void dispatch() {
        try {
            if (this.catchExceptions) {
                try {
                    this.runnable.run();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        this.exception = (Exception)throwable;
                    }
                    this.throwable = throwable;
                }
            } else {
                this.runnable.run();
            }
        }
        finally {
            this.finishedDispatching(true);
        }
    }

    public Exception getException() {
        return this.catchExceptions ? this.exception : null;
    }

    public Throwable getThrowable() {
        return this.catchExceptions ? this.throwable : null;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isDispatched() {
        return this.dispatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedDispatching(boolean bl) {
        this.dispatched = bl;
        if (this.notifier != null) {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notifyAll();
            }
        }
        if (this.listener != null) {
            this.listener.run();
        }
    }

    @Override
    public String paramString() {
        String string;
        switch (this.id) {
            case 1200: {
                string = "INVOCATION_DEFAULT";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        return string + ",runnable=" + this.runnable + ",notifier=" + this.notifier + ",catchExceptions=" + this.catchExceptions + ",when=" + this.when;
    }

    static {
        AWTAccessor.setInvocationEventAccessor(new AWTAccessor.InvocationEventAccessor(){

            @Override
            public void dispose(InvocationEvent invocationEvent) {
                invocationEvent.finishedDispatching(false);
            }
        });
    }
}

